#!perl 

use strict;
use warnings;

use lib 'lib';

use Test::More tests => 6;
use Test::MockModule;

my $module = 'Logger';
use_ok( $module ) or exit;

can_ok( $module, 'log_message' );

{
   local $Logger::REPORT_TIME   = 0;
   local $Logger::REPORT_CALLER = 0;

   my $message;
   my $logger = Test::MockModule->new( 'Logger' );
   $logger->mock( write_message => sub { $message = shift } );

   Logger::log_message( 'bez dekoracji' );
   is( $message, "bez dekoracji\n", 'log_message(  ) nie powinno domylnie dodawa czasu ani woajcego' );

   $Logger::REPORT_TIME   = 1;
   Logger::log_message( 'tylko czas' );
   (my $time = localtime(  )) =~ s/:\d+ /:\\d+ /;
   like( $message, qr/^\[$time\] tylko czas$/, '... czas dodany na yczenie' );

   $Logger::REPORT_CALLER = 1;
   my $line   = __LINE__ + 1;
   Logger::log_message( 'czas i wywoujcy' );
   like( $message, qr/^\[$time\] czas i wywoujcy z main:$line w $0$/, '... czas i wywoujcy dodany na yczenie' );

   $Logger::REPORT_TIME   = 0;
   $line  = __LINE__ + 1;
   Logger::log_message( 'tylko wywoujcy' );
   like( $message, qr/^tylko wywoujcy z main:$line w $0$/, '... wywoujcy dodany tylko na yczenie' );
}
