#!perl
  
use strict;
use warnings;
  
use Test::Harness::Straps;
my $strap = Test::Harness::Straps->new();
  
for my $file (@ARGV)
{
    next unless -f $file;
    my %results = $strap->analyze_file( $file );
    printf <<END_REPORT, $file, @results{qw( max seen ok skip todo bonus )};
Wyniki dla %s
    Oczekiwanych testw: %d
    Uruchomionych testw: %d
    Udanych testw: %d
    Pominitych testw: %d
    Testw do zrobienia: %d
    Udanych testw do zrobienia: %d
END_REPORT
}
