package Queue::Test;

use base 'Test::Class';

use Queue;
use Test::More;

sub size : Test(4)
{
   my $q1 = Queue->new(  );
   isa_ok( $q1, 'Queue' );
   is( $q1->size(  ), 0, 'pusta kolejka' );

   my $q2 = Queue->new(qw( czoem bonjour ));
   isa_ok( $q2, 'Queue' );
   is( $q2->size(  ), 2, 'kolejka zawierajca jakie elementy' );
}

sub enqueue : Test(2)
{
   my $queue = Queue->new(  );
   isa_ok( $queue, 'Queue' );

   $queue->enqueue($_) for qw( czoem bonjour );
   is( $queue->size(  ), 2, 'kolejka jest teraz dusza' );
}

sub dequeue : Test(6)
{
   my $queue = Queue->new(  );
   isa_ok( $queue, 'Queue' );

   is( $queue->dequeue, undef, 'pusta kolejka' );

   $queue->enqueue($_) for qw( czoem bonjour );
   is( $queue->size(  ),    2,         'pusta kolejka jest teraz dusza'  );
   is( $queue->dequeue(  ), 'czoem',  'pierwszy element'   );
   is( $queue->dequeue(  ), 'bonjour', 'drugi element'  );
   is( $queue->size(  ),    0,         'kolejka jest teraz krtsza' );
}

1;
