#----------------------------------------------------------------------
package Monitor;
require Exporter;
@ISA = ("Exporter");
@EXPORT = qw(monitor unmonitor);
use strict;


sub 
monitor {
   my ($r_zmien, $nazwa) = @_;
   my ($typ) = ref($r_zmien);
   if ($typ =~ /SCALAR/) {
       return tie $$r_zmien, 'Monitor::Skalar', $r_zmien, $nazwa;
   } elsif ($typ =~ /ARRAY/) {
       return tie @$r_zmien, 'Monitor::Tablica', $r_zmien, $nazwa;
   } elsif ($typ =~ /HASH/) {
       return tie %$r_zmien, 'Monitor::Hasz', $r_zmien, $nazwa;
   } else {
       print STDERR "wymaga odw. do skalara, tablicy lub hasza" unless $typ;
   }
}
sub unmonitor {
   my ($r_zmien) = @_;
   my ($typ) = ref($r_zmien);
   my $obj;
   if ($typ =~ /SCALAR/) {
       Monitor::Skalar->unmonitor($r_zmien);
   } elsif ($typ =~ /ARRAY/) {
       Monitor::Tablica->unmonitor($r_zmien);
   } elsif ($typ =~ /HASH/) {
       Monitor::Hasz->unmonitor($r_zmien);
   } else {
       print STDERR "wymaga odw. do skalara, tablicy lub hasza" unless $typ;
   } 
}
#------------------------------------------------------------------------
package Monitor::Skalar;


sub TIESCALAR {
   my ($pkg, $rwart, $nazwa) = @_;
   my $obj = [$nazwa, $$rwart];
   bless $obj, $pkg;
   return $obj;
}


sub FETCH {
   my ($obj) = @_;
   my $wart = $obj->[1];
   print STDERR 'Odczyt  $', $obj->[0], " ... $wart \n";
   return $wart;
}
sub STORE {
   my ($obj, $wart) = @_;
   print STDERR 'Zapis   $', $obj->[0], " ... $wart \n";
   $obj->[1] = $wart;
   return $wart;
}


sub unmonitor {
   my ($pkg, $r_zmien) = @_;
   my $wart;
   {
      my $obj = tied $$r_zmien;
      $wart = $obj->[1];
      $obj->[0] = "_NIEMONITOROWANA_";
   }
   untie $$r_zmien;
   $$r_zmien = $wart;
}


sub DESTROY {
   my ($obj) = @_;
   if ($obj->[0] ne '_NIEMONITOROWANA_') {
      print STDERR 'Koniec  $', $obj->[0];
   }
}
#------------------------------------------------------------------------
package Monitor::Tablica;

sub TIEARRAY {
   my ($pkg, $rtablica, $nazwa) = @_;
   my $obj = [$nazwa, [@$rtablica]];
   bless $obj, $pkg;
   return $obj;
}


sub FETCH {
   my ($obj, $indeks) = @_;
   my $wart = $obj->[1]->[$indeks];
   print STDERR 'Odczyt  $', $obj->[0], "[$indeks] ... $wart\n";
   return $wart;
}


sub STORE {
   my ($obj, $indeks, $wart) = @_;
   print STDERR 'Zapis   $', $obj->[0], "[$indeks] ... $wart\n";
   $obj->[1]->[$indeks] = $wart;
   return $wart;
}


sub DESTROY {
   my ($obj) = @_;
   if ($obj->[0] ne '_NIEMONITOROWANA_') {
      print STDERR 'Koniec  %', $obj->[0];
   }
}


sub unmonitor {
   my ($pkg, $r_zmien) = @_;
   my $r_tablica;
   {
      my $obj = tied @$r_zmien;
      $r_tablica = $obj->[1];
      $obj->[0] = "_NIEMONITOROWANA_";
   }
   untie @$r_zmien;
   @$r_zmien = @$r_tablica;
}
#------------------------------------------------------------------------
package Monitor::Hasz;
sub TIEHASH {
   my ($pkg, $rhasz, $nazwa) = @_;
   my $obj = [$nazwa, {%$rhasz}];
   return (bless $obj, $pkg);
}


sub CLEAR {
   my ($obj) = @_;
   print STDERR 'Wyczysz.%', $obj->[0], "\n";
}


sub FETCH {
   my ($obj, $indeks) = @_;
   my $wart = $obj->[1]->{$indeks};
   print STDERR 'Odczyt  $', $obj->[0], "{$indeks} ... $wart\n";
   return $wart;
}


sub STORE {
   my ($obj, $indeks, $wart) = @_;
   print STDERR 'Zapis   $', $obj->[0], "{$indeks} ... $wart\n";
   $obj->[1]->{$indeks} = $wart;
   return $wart;
}


sub DESTROY {
   my ($obj) = @_;
   if ($obj->[0] ne '_NIEMONITOROWANA_') {
      print STDERR 'Koniec  %', $obj->[0];
   }
}
sub unmonitor {
   my ($pkg, $r_zmien) = @_;
   my $r_hasz;
   {
      my $obj = tied %$r_zmien;
      $r_hasz = $obj->[1];
      $obj->[0] = "_NIEMONITOROWANA_";
   }
   untie %$r_zmien;
   %$r_zmien = %$r_hasz;
}
1;
