$poziom = -1; # Poziom wcicia

sub ladnie_drukuj {
    my $zmien;
    foreach $zmien (@_) {
        if (ref ($zmien)) {
            drukuj_odwolanie($zmien);
        } else {
            drukuj_skalar($zmien);
        }
    }
}

sub drukuj_skalar {
    ++$poziom;
    my $zmien = shift;
    drukuj_z_wcieciami ($zmien);
    --$poziom;
}

sub drukuj_odwolanie {
    my $r = shift;
    if (exists ($juz_widziane{$r})) {
        drukuj_z_wcieciami ("$r (wystpio kolejny raz)");
        return;
    } else {
        $juz_widziane{$r}=1;
    }
    my $typ_odwolania = ref($r);
    if ($typ_odwolania eq "ARRAY") {
        drukuj_tablice($r);
    } elsif ($typ_odwolania eq "SCALAR") {
        print "Ref -> $r";
        drukuj_skalar($$r);
    } elsif ($typ_odwolania eq "HASH") {
        drukuj_hasz($r);
    } elsif ($typ_odwolania eq "REF") {
        ++$poziom;
        drukuj_z_wcieciami("Odw -> ($r)");
        drukuj_odwolanie($$r);
        --$poziom;
    } else {
        drukuj_z_wcieciami ("$typ_odwolania (nieobsugiwany)");
    }
}


sub drukuj_tablice {
    my ($r_tablica) = @_;
    ++$poziom;
    drukuj_z_wcieciami ("[ # $r_tablica");
    foreach $zmien (@$r_tablica) {
        if (ref ($zmien)) {
            drukuj_odwolanie($zmien);
        } else {
            drukuj_skalar($zmien);
        }
    }
    drukuj_z_wcieciami ("]");
    --$poziom;
}


sub drukuj_hasz {
    my($r_hasz) = @_;
    my($klucz, $wart);
    ++$poziom; 
    drukuj_z_wcieciami ("{ # $r_hasz");
    while (($klucz, $wart) = each %$r_hasz) {
        $wart = ($wart ? $wart : '""');
        ++$poziom;
        if (ref ($wart)) {
            drukuj_z_wcieciami ("$klucz => ");
            drukuj_odwolanie($wart);
        } else {
            drukuj_z_wcieciami ("$klucz => $wart");
        }
        --$poziom;
    }
    drukuj_z_wcieciami ("}");
    --$poziom;
}


sub drukuj_z_wcieciami {
    $spacje = ":  " x $poziom;
    print "${spacje}$_[0]\n";
}
