package Towar;


my $_podatek_od_sprzedazy = 8.5;  # 8,5% dodane do ceny kadego 
                                  # elementu po naliczeniu rabatu

sub nowy {
    my ($pakiet, $nazwa, $cena, $rabat) = @_;
    bless {
       # Atrybuty oznaczamy znakiem podkrelenia, co ma wiadczy
       # o tym, e s prywatne (to tylko konwencja)
        _nazwa => $nazwa, _cena => $cena, _rabat => $rabat
    }, $pakiet;
}


# Metody akcesorw
sub podatek_od_sprzedazy {shift; @_ ? $_podatek_od_sprzedazy = shift : $_podatek_od_sprzedazy}
sub nazwa {my $obj = shift; @_ ? $obj->{_nazwa} = shift : $obj->{_nazwa}}
sub rabat {my $obj = shift; @_ ? $obj->{_rabat} = shift 
                                : $obj->{_rabat}}
sub cena  {my $obj = shift; @_ ? $obj->{_cena} = shift
                                : $obj->{_cena} - $obj->_rabat}
}


sub cena_netto {
    my $obj = shift;
    return $obj->cena * (1 + $obj->podatek_od_sprzedazy / 100);
}
#--------------------------------------------------------------------------
package Podzespol;
@ISA = qw(Towar);


#--------------------------------------------------------------------------
package Monitor;
@ISA = qw(Podzespol);
# Chwilowo kodujemy ceny i rabaty na stae
sub nowy { $pakiet = shift; $pakiet->SUPER::nowy("Monitor", 400, 15)}


#--------------------------------------------------------------------------
package CDROM;
@ISA = qw(Podzespol);
sub nowy { $pakiet = shift; $pakiet->SUPER::nowy("CDROM", 200, 5)}


#--------------------------------------------------------------------------
package Komputer;
@ISA = qw(Towar);


sub nowy {
    my $pakiet = shift; 
    my $obj = $pakiet->SUPER::nowy("Komputer", 0, 0); # Warto-zapeniacz
    $obj->{_podzespoly} = [];
    $obj->podzespoly(@_);
    $obj;
}

# Akcesory
sub podzespoly {
    my $obj = shift;
    @_ ? push (@{$obj->{_podzespoly}}, @_)
       : @{$obj->{_podzespoly}};
}
sub cena {
    my $obj = shift;
    my $cena = 0;
    my $podzespol;
    foreach $podzespol ($obj->podzespoly()) {
        $cena += $podzespol->cena();
    }
    $cena;
}








$cdrom   = nowy CDROM   ("Toshiba 5602");


$monitor = nowy Monitor ("Viewsonic 15GS");
print $monitor->cena_netto();


$komputer = nowy Komputer($monitor, $cdrom); 
print $komputer->cena_netto();
