#!/opt/bin/perl
use strict;
#--------------------------------------------------------------
# perlman: przegldarka podrcznikw man w Perlu
#--------------------------------------------------------------
use Tk;

print STDERR "Przeszukiwanie katalogw man\n";
scout_man_dirs();
print STDERR "Uruchamianie interfejsu uytkownika ...";
create_ui();
print STDERR "Gotowe \n";
MainLoop();
exit(0);

#-------------------------------------------------------------------
my $menu_headings;        # Przycisk menu "Nazwy"
my $ignore_case;          # 1 jeli w menu Szukaj zaznaczono pole wyboru
my $match_type;           # '-regexp' lub '-exact'.
my $text;                 # Gwny widget tekstowy
my $show;                 # Widget tekstowy "Poka" 
my $search;               # Widget tekstowy "Szukaj"
my %sections;               # Odwzorowanie sekcji podrcznikw ('1', '3' ,'3n' itp.)
                          # na list tematw w danej sekcji

sub show_man {
    my $entry = $show->get();   # pobierz wpis z $show
    my ($man, $section) = ($entry =~ /^(\w+)(\(.*\))?/);
    if ($section && (!is_valid_section($section))) {
        undef $section ;
    }
    my $cmd_line = get_command_line($man, $section); # wykorzystywane przez open

    # Usu wszystko, co ma zwizek z biec stron (tre, menu, znaczniki)
    $text->delete('1.0', 'end');  # usu biec stron
    $text->insert('end', "Formatowanie \"$man\" .. czekaj", 'section');
    $text->update();                  # Wprowad dotychczasowe zmiany w widgecie tekstowym
    $menu_headings->menu()->delete(0,'end'); # Usu biece nagwki
    my $mark;
    foreach $mark ($text->markNames) {  # usu wszystkie znaczniki
        $text->markUnset($mark);
    }

    # Interfejs uytkownika jest teraz "czysty". Otwieramy plik
    if (!open (F, $cmd_line)) {
        # Komunikaty o bdach przekazywane do widgetu tekstowego
        $text->insert('end', "\nBd przy uruchamianiu man lub rman");
        $text->update();
        return;
    }
    # Usu komunikat "Formatowanie $man ..." 
    $text->delete('1.0', 'end');
    my $lines_added = 0; my $line;
    while ($line = <F>) {
        $lines_added = 1;
        # Jeli pierwszy znak jest wielk liter, to prawdopodobnie jest sekcja
        if ($line =~ /^[A-Z]/) {  
            # Prawdopodobnie nagwek sekcji
            ($mark = $line) =~ s/\s.*$//g;  # $mark zawiera tytu sekcji
            my $index = $text->index('end');# zaznaczamy biec lokalizacj koca
            # Nadajemny znacznik 'section' tytuowi sekcji
            $text->insert('end', "$mark\n\n", 'section');
            # Tworzymy wpis menu. Odpowiednia procedura wywoa metod 'see'
            # widgetu tekstowego, co spowoduje pzrejscie do zanotowanego wyej indeksu
            $menu_headings->command(
                    '-label' => $mark,
                    '-command' => [sub {$text->see($_[0])},$index])
        } else {
            $text->insert('end', $line); # Zwyky tekst -- po prostu wstawiamy.
        }
    }
    if ( ! $lines_added ) {
        $text->insert('end', "Niestety, nie ma informacji o $man");
    }
    close(F);
}

sub get_command_line {
    my ($man, $section) = @_; # Majc podany temat i sekcj, konstruujemy
                              # uniksowy wiersz polecenia
    if ($section) {
        $section =~ s/[()]//g; # usuwamy nawiasy
        return "man -s $section $man 2> /dev/null | rman |";
    } else {
        return "man $man 2> /dev/null | rman |";
    }
}

sub create_ui {
    my $top = MainWindow->new();

    # MENU

    # Pasek menu
    my $menu_bar = $top->Frame()->pack('-side' => 'top', '-fill' => 'x');

    # Menu Plik
    my $menu_file = $menu_bar->Menubutton('-text' => 'Plik',
                                          '-relief' => 'raised',
                                          '-borderwidth' => 2,
					   font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
                                          )->pack('-side' => 'left',
                                                  '-padx' => 2,
                                                  );
    $menu_file->separator();
    $menu_file->command('-label' => 'Wyjcie', 
			font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2', 
			'-command' => sub {exit(0)});

    #Menu sekcji
    $menu_headings = $menu_bar->Menubutton('-text' => 'Nagwki',
                                           '-relief' => 'raised',
                                           '-borderwidth' => 2,
					   font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
                                           )->pack('-side' => 'left',
                                                   '-padx' => 2,
                                                   );
    $menu_headings->separator();
    #Menu wyszukiwania
    my $search_mb = $menu_bar->Menubutton('-text'         => 'Szukaj',
                                          '-relief'       => 'raised',
                                          '-borderwidth'  => 2,
					   font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
                                          )->pack('-side' => 'left',
                                                  '-padx' => 2
                                               );
    $match_type = "-regexp"; $ignore_case = 1;
    $search_mb->separator();

    # Dopasowanie wg wyraenia regularnego
    $search_mb->radiobutton('-label'    => 'Wyraenie regularne',
                            '-value'    => '-regexp',
			    font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2',
                            '-variable' => \$match_type);
    # Dopasowanie dokadne
    $search_mb->radiobutton('-label'    => 'Dokadne dopasowanie',
                            '-value'    => '-exact',
			    font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2',
                            '-variable' => \$match_type);
    $search_mb->separator();
    # Ignorowanie wielkoci liter
    $search_mb->checkbutton('-label'    => 'Ignorowa wielko liter?',
			    font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2',
                            '-variable' => \$ignore_case);


    # Menu sekcji
    my $menu_sections = $menu_bar->Menubutton('-text' => 'Sekcje',
                                              '-relief' => 'raised',
                                              '-borderwidth' => 2,
					   font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
                                              )->pack('-side' => 'left',
                                                      '-padx' => 2,
                                                      );
    # Menu sekcji wypeniamy kluczami tablicy asocjacyjnej %sections
    my $section_name;
    foreach $section_name (sort keys %sections) {
        $menu_sections->command (
                 '-label' => "($section_name)",
				 font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2',
                 '-command' => [\&show_section_contents, $section_name]);
    }
    # TEXT

    $text = $top->Text ('-width' =>  80, 
                        '-height' => 40)->pack();
    $text->tagConfigure('section', 
                        '-font' => '-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1');
    $text->bind('<Double-1>', \&pick_word);
    $top->Label('-text' => 'Poka:', font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
)->pack('-side' => 'left');

    $show = $top->Entry ('-width'   =>  20,
                         )->pack('-side' => 'left');
    $show->bind('<KeyPress-Return>', \&show_man);

    $top->Label('-text' => 'Szukaj:',font => '-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-2'
                )->pack('-side' => 'left', '-padx' => 10);
    $search = $top->Entry ('-width' => 20,
                           )->pack('-side' => 'left');
    $search->bind('<KeyPress-Return>', \&search);
}

sub is_valid_section {
    my $section= $_[0];
    return 0 unless $section =~ /\((.*?)\)/;
    my $section = $1;
    my $s;
    foreach $s (keys %sections) {
        if (lc($s) eq lc($section)) {
            return 1;
        }
    }
    0;
}

sub pick_word {
    my $start_index = $text->index('insert wordstart');
    my $end_index = $text->index('insert lineend');
    my $line = $text->get($start_index, $end_index);
    my ($page, $section) = ($line =~ /^(\w+)(\(.*?\))?/); 
    return unless $page;
    $show->delete('0', 'end');
    if ($section && is_valid_section($section)) {
        $show->insert('end', "$page${section}");
    } else {
        $show->insert('end', $page);
    }
    show_man();
}

sub show_section_contents {
    my $current_section = $_[0];
    $text->delete('1.0', 'end');
    $menu_headings->menu()->delete(0,'end');
    my ($i, $len);
    return unless exists $sections{$current_section};
    my $spaces = " " x 40;
    my $words_in_line = 0;  # Kiedy to osignie wart. 3 -- dajemy nowy wiersz
    my $man;
    foreach $man (@{$sections{$current_section}}) {
        $text->insert('end', $man . substr($spaces,0, 24 - length($man)));
        if (++$words_in_line  == 3) {
            $text->insert('end', "\n");
            $words_in_line = 0;
        }
    }
}

sub search {
    my $search_pattern = $search->get();
    $text->tagDelete('search');
    $text->tagConfigure('search', 
                        '-background' => 'yellow', 
                        '-foreground' => 'red');

    my $current = '1.0'; my $length = '0';
    while (1) {
        if ($ignore_case) {
            $current = $text->search('-count' => \$length,
                                     $match_type, 
                                     '-nocase',
                                     '--',
                                     $search_pattern,
                                     $current,
                                     'end');
        } else {
            $current = $text->search('-count' => \$length,
                                     $match_type, 
                                     '--',
                                     $search_pattern,
                                     $current,
                                     'end');
        }
        last if (!$current);
        $text->tagAdd('search', $current, "$current + $length char");
        $current = $text->index("$current + $length char");
    }
}


use Cwd;
sub scout_man_dirs {
    my (@man_dirs,$man_dir, $section);
    if ($ENV{MANPATH}) {
        @man_dirs = split (/:/, $ENV{MANPATH});
    } else {
        push (@man_dirs, "/usr/man");
    }
    # Konwerujemy wszystkie wzgldne cieki dostpu do podrcznikw na bezwzgldne
    # dodajc przed nimi $cwd
    my $cwd = cwd();
    foreach $man_dir (@man_dirs) {
        next if ($man_dir =~ m|^/|);
        $man_dir = "$cwd/$man_dir"; # Modyfikacja wpisu w man_dirs
    }
    foreach $man_dir (@man_dirs) {
        chdir $man_dir || next;
        # Teraz jestemy np. w /usr/man. Badamy wszystkie podkatalogi
        my @section_dirs = grep {-d $_} <man*>;
        my $section_dir;
        # @section_dirs zawiera man1, man2, man3s itd.
        foreach $section_dir (@section_dirs) {
            chdir $section_dir || next;
            ($section = $section_dir) =~ s/^man//;
            push (@{$sections{$section}}, <*.$section>);
            chdir "..";
        }
        chdir "..";
    }
    # Wszystkie sekcje stron podrcznikw zostay przeanalizowane; usuwamy duplikaty
    foreach $section (keys %sections) {
        my @new_list;
        my %seen;
        @new_list = sort (grep (!$seen{$_}++, @{$sections{$section}}));
        # Change all entries like cc.1 to cc(1)
        foreach (@new_list) {
            $_ =~ s/[.](.*)/($section)/;
        }
        $sections{$section} = \@new_list;
    }
}
