
package TieFile;
use Symbol;
use strict;
# Obiekt konstruowany w TIEARRAY jest tablic, a poniej przedstawiono
# jego pola
my $F_POZYCJE    = 0;    # Lista pozycji wyszukiwania (jedna dla kadej linijki)
my $F_UCHWYT_PLIKU = 1;  # Otwarty uchwyt pliku


sub TIEARRAY {
   my ($pakiet, $nazwa_pliku) = @_;
   my $fh = gensym();
   open ($fh, $nazwa_pliku) || die "Nie mona otworzy pliku: $!\n";
   bless [  [0],  # Zerowal linijka ma pozycj 0
            $fh
         ], $pakiet;
}


sub FETCH {
   my ($obj, $indeks) = @_;
   # Czy t linijk ju odczytywalimy?
   my $rl_pozycje = $obj->[$F_POZYCJE];
   my $fh = $obj->[$F_UCHWYT_PLIKU];
   if ($indeks > @$rl_pozycje) {
       $obj->odczytaj_az_do ($indeks);
   } else {
       # wyszukuj (seek) do odpowiedniej pozycji w pliku
       seek ($fh, $rl_pozycje->[$indeks], 0); 
   }
   return (scalar <$fh>);  # Zwr pojedynczy wiersz przez ewaluacj <$fh>
                           # w kontekcie skalarnym
}


sub STORE {
   die "Przykro nam. Wprowadzanie zmian za pomoc TieFile nie jest moliwe.\n";
}


sub DESTROY {
   my ($obj) = @_;
   # zamknij uchwyt pliku
   close($obj->[$F_UCHWYT_PLIKU]);
}


sub odczytaj_az_do {
   my ($obj, $indeks) = @_;
   my $rl_pozycje = $obj->[$F_POZYCJE];
   my $ostatni_indeks = @$rl_pozycje - 1;
   my $ostatnia_pozycja = $rl_pozycje->[$ostatni_indeks];
   my $fh = $obj->[$F_UCHWYT_PLIKU];
   seek ($fh, $ostatnia_pozycja, 0); 
   my $buf;
   while (defined($buf = <$fh>)) {
      $ostatnia_pozycja += length($buf);
      $ostatni_indeks++;
      push (@$rl_pozycje, $ostatnia_pozycja);
      last if $ostatni_indeks > $indeks;
   }
}


1;


if (!caller) {
    # test
    my @lista;
    # odwzorowanie niniejszego pliku na @lista 
    tie @lista, 'TieFile', 'TieFile.pm'; 
    my $i;

    for ($i = 10; $i >= 0; --$i) {
        print "Linijka $i ", $lista[$i];
    }
}
