open (F, "oscar.txt") || die "Nie mona otworzy bazy danych: $:";
%indeks_kategorii = (); %indeks_lat = ();
while ($linijka = <F>) {
    chomp $linijka;
    ($rok, $kategoria, $nazwa) = split (/:/, $linijka);
    utworz_wpis($rok, $kategoria, $nazwa) if $nazwa;
}


sub utworz_wpis {             # utworz_wpis (rok, kategoria, nazwa)
    my($rok, $kategoria, $nazwa) = @_;
    # Utwrz anonimowa tablic dla kadego wpisu
    $rlWpis = [$rok, $kategoria, $nazwa];
    # Dodajemy j do dwch indeksw
    push (@{$indeks_lat {$rok}}, $rlWpis);         # Wg roku
    push (@{$indeks_kategorii{$kategoria}}, $rlWpis);  # Wg kategorii
}
sub drukuj_wpisy_roku {
    my($rok) = @_;
    print ("Rok : $rok \n");
    foreach $rlWpis (@{$indeks_lat{$rok}}) {
        print ("\t",$rlWpis->[1], "  : ",$rlWpis->[2], "\n");
    }
}

sub drukuj_wszystkie_wpisy_roku {
    foreach $rok (sort keys %indeks_lat) {
        drukuj_wpisy_roku($rok);
    }
}

sub drukuj_wpis {
    my($rok, $kategoria) = @_;
    foreach $rlWpis (@{$indeks_lat{$rok}}) {
        if ($rlWpis->[1] eq $kategoria) {
            print "$kategoria ($rok), ", $rlWpis->[2], "\n";
            return;
        }
    }
    print "Brak wpisu w kategorii $kategoria ($rok) \n";
}

