# Wyuskuje z pliku kolumny tekstu
# Sposb uycia : col [-s<n>] zakres_kolumny1, zakres-kolumny2, pliki ...
# gdzie zakres-kolumny okrela si jako kol1-kol2 (kolumna 1 do kolumny2) 
#         lub kol1+n, gdzie n jest liczb kolumn.
$dlugosc = 0;          # 0 => wejcie linijka po linijce, ew. format ustalony
@pliki = ();           # Lista plikw
$otworz_nowy_plik = 1; # Zmuszamy pobierz_nast_wiersz() do otwarcia pierwszego pliku
$debugowanie = 0;      # Wczane opcja -d wiersza polece

generuj_czesc1();
generuj_czesc2();
generuj_czesc3();
kol();           # podpr. kol jest ju utworzona. Wywoajmy j!
exit(0);


#------------------------------------------------------------------
sub generuj_czesc1 {
    # Generowanie wstpnego wariantu kodu podprocedury kol()
    $kod  = 'sub kol { my $tmp;';    # Zwrmy uwag na zastosowanie apostrofw
    $kod .= 'while (1) {$s = pobierz_nast_wiersz(); $kol = "";';
    $ogranicznik = '|';
}

#------------------------------------------------------------------
sub generuj_czesc2 {
    # Przetwarzamy argumenty
    foreach $arg (@ARGV) {
        if (($kol1, $kol2) = ($arg =~ /^(\d+)-(\d+)/)) {
            $kol1--;# Startujemy od 0
            $przesuniecie = $kol2 - $kol1;
            dodaj_zakres($kol1, $przesuniecie);
        } elsif (($kol1, $przesuniecie) = ($arg =~ /^(\d+)\+(\d+)/)) {
            $kol1--;
            dodaj_zakres($kol1, $przesuniecie);
        } elsif ($dlugosc = ($arg =~ /-s(\d+)/)) {
            # nic nie robi
        } elsif ($arg =~ /^-d/) {
            $debugowanie = 1;
        } else {
            # to musi by nazwa pliku
            push (@pliki, $arg);
        }
    }
}

#------------------------------------------------------------------
sub generuj_czesc3 {
    $kod .= 'print $kol, "\n";}}';

    print $kod if $debugowanie; # opcja -d wcza debugowanie
    eval $kod;
    if ($@) {
        die "Bd ...........\n $@\n $kod \n";
    }
}

#------------------------------------------------------------------
sub dodaj_zakres { 
    my ($kol1, $ileZnakow) = @_;
    # substr zgasza problem (przy -w) jeli wykroczymy za koniec wiersza
    # Aby temu zapobiec, dopeniamy acuch spacjami (o ile konieczne)
    $kod .= "\$s .= ' ' x ($kol1 + $ileZnakow - length(\$s))";
    $kod .= "    if (length(\$s) < ($kol1+$ileZnakow));";
    $kod .= "\$tmp = substr(\$s, $kol1, $ileZnakow);";
    $kod .= '$tmp .= " " x (' . $ileZnakow .  ' - length($tmp));';
    $kod .= "\$kol .= '$ogranicznik' . \$tmp; ";
}

#------------------------------------------------------------------
sub pobierz_nast_wiersz {
    my($buf);

  NASTPLIK:
    if ($otworz_nowy_plik) {
        $plik = shift @pliki || exit(0);
        open (F, $plik) || die "$@ \n";
        $otworz_nowy_plik = 0;
    }
    if ($dlugosc) {
        read(F, $buf, $dlugosc);
    } else {
        $buf = <F>;
    }
    if (! $buf) {
        close(F);
        $otworz_nowy_plik = 1;
        goto NASTPLIK;
    }
    chomp($buf);
    # Konwertuje tabulatory na spacje (zakadamy dugo taba == 8)

    # najpierw zamieniamy pocztkowe tabulatory (typowy przypadek)
    $buf =~ s/^(\t+)/' ' x (8 * length($1))/e;

    # A teraz szukamy zagniedonych tabulatorw. Musimy je zamienia po jednym
    # i std ptla while. Przy kadym przejciu ptli tabulator zamieniany jest na
    # tyle spacji, ile zostao do nastpnej granicy tabulatora. Ptla koczy si,
    # gdy nie pozostay ju adne "taby".
    1 while ($buf =~ s/\t/' ' x (8 - length($`)%8)/e);

    $buf;
}
