#!/usr/bin/perl -w

use 5.004;
use strict; # wymus deklarowanie zmiennych przy uzyciu cudzyslowow
use CGI qw(:standard); # importuj skroty
use Fcntl qw(:flock);  # importuje LOCK_EX, LOCK_SH i #LOCK_NB

sub zakoncz { # funkcja pozwalajaca w elegancki sposob #reagowac na bledy
    my $blad = "@_";
    print h1("BLAD"), p($blad), end_html;
    die $blad;
}

my(
    $PLIK,     # nazwa pliku z archiwum
    $NAJWYZEJ, # ile pozycji przechowywac
    $TYTUL,    # tytul strony i naglowek
    $aktualne, # nowa pozycja w ksiazce
    @pozycje,  # wszystkie wpisy
    $pozycja,  # jedna, konkretna pozycja
);

$TYTUL = "Prosta ksiazka gosci";
$PLIK = "/tmp/archiwum_ksiazki_gosci"; # lub #gdziekolwiek
$NAJWYZEJ = 10;

print header, start_html($TYTUL), h1($TYTUL);

$aktualne = CGI->new(); # biezace zgloszenie
if ($aktualne->param("wiadomosc")) { # w porzadku, mamy nowy wpis
    $aktualne->param("data", scalar localtime); # zapisz date i godzine
    @pozycje = ($aktualne);
}

# otworz plik w trybie odczyt-zapis (zachowujac jego zawartosc)
open(ARCHIWUM, "+<$PLIK") || zakoncz("nie moge otworzyc $PLIK: $!");

# zablokuj plik
flock(ARCHIWUM, LOCK_EX) || zakoncz("nie moge zablokowac $PLIK: $!");

# wczytaj $NAJWYZEJ pozycji, z najnowsza na pierwszym miejscu
while (!eof(UCHWYT) && @pozycje < $NAJWYZEJ) {
    $pozycja = CGI->new(\*ARCHIWUM); # przekaz uchwyt pliku jako referencje
    push @pozycje, $pozycja;
}
seek(ARCHIWUM, 0, 0) || zakoncz("nie moge przesunac sie do poczatku $PLIK: $!");
foreach $pozycja (@pozycje) {
    $pozycja->save(\*ARCHIWUM); # przekaz uchwyt pliku jako referencje
}
truncate(ARCHIWUM, tell(ARCHIWUM)) || zakoncz("nie moge obciac pliku $PLIK: $!");
close(ARCHIWUM) || zakoncz("nie moge zamknac $PLIK: $!");

print hr, start_form; # hr() tworzy pozioma kreske <HR>
print p("Imie:", $aktualne->textfield(
    -NAME => "imie"));
print p("Wiadomosc:", $aktualne->textfield(
    -NAME => "wiadomosc",
    -OVERRIDE => 1, # usuwa poprzednia wiadomosc
    -SIZE => 50));
print p(submit("wyslij"), reset("wyczysc"));
print end_form, hr;

print h2("Wczesniejsze wpisy");
foreach $pozycja (@pozycje) {
    printf("%s [%s]: %s",
    $pozycja->param("data"),
    $pozycja->param("imie"),
    $pozycja->param("wiadomosc"));
    print br();
}
print end_html;
