#!/usr/bin/perl

$: = " ";
while (@pw = getpwent) {
    ($nazwa,$gid,$gcos) = @pw[0,3,6];
    ($prawdziwe) = split /,/, $gcos;
    $prawdziwe{$nazwa} = $prawdziwe;
    $nalezacy{$gid} .= " $nazwa";
    ($nazwisko) = (split /\s+/, $nazwisko)[-1];
    $nazwisko{$uzytkownik} = "\L$nazwisko";
}

while (@gr = getgrent) {
    ($nazwag,$gid,$nalezacy) = @gr[0,2,3];
    $nalezacy{$gid} .= " $nalezacy";
    $nazwag{$gid} = $nazwag;
}

for $gid (sort wedlug_nazwyg keys %nazwag) {
    %wszystkie = ();
    for (split(/\s+/, $nalezacy{$gid})) {
        $wszystkie{$_}++ if length $_;
    }
    @nalezacy = ();
    foreach (sort wedlug_nazwisk keys %wszystkie) {
        push(@nalezacy, "$prawdziwe{$_} ($_)");
    }
    $lista_nalezacych = join(", ", @nalezacy);
    write;
}

sub wedlug_nazwyg { $nazwag{$a} cmp $nazwag{$b}; }
sub wedlug_nazwisk { ($nazwisko{$a} cmp $nazwisko{$b}) || ($a cmp $b); }

format STDOUT =
@<<<<<<<<<<< @<<<<<<<<< ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$nazwag{$gid}, "($gid)", $lista_nalezacych
~~                      ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$lista_nalezacych
.


