#!/usr/bin/perl
#simpledb.plx
use warnings;
use strict;
use POSIX;
use SDBM_File;    # lub GDBM_File  /   NDBM_File   /   AnyDBM_File... itd.

my %dbm;
my $db_file="simpledb.dbm";

tie  %dbm,  'SDBM_File',  $db_file,  O_CREAT|O_RDWR,   0644;

if (tied  %dbm)   {
    print   "Plik $db_file jest otwarty. \n";
}   else   {
    die "Przykro mi  nie jest moliwe otwarcie $db_file\n";
}
$_  =  "";   #upewnij si,  e $_ jest zdefiniowana

until  (/^q/i)   {

print  "Co chcesz zrobi?  ('o' wywietla opcje): ";
chomp($_  =  <STDIN>);

if ($_ eq "o")  {  dboptions()  }
elsif ($_ eq "r")  {  readdb()  }
elsif ($_ eq "l")  {  listdb()  }
elsif ($_ eq "w")  {  writedb()  }
elsif ($_ eq "d")  {  deletedb()  }
elsif ($_ eq "x")  {  cleardb()  }
else {  print  "Nierozpoznana opcja. \n"; }
}

untie %dbm;

#***  Procedury obsugujce opcje  ***#

sub dboptions {
     print<<EOF;
     Dostpne opcje:
     o - wywietla opcje
     r - odczytanie rekordu
     l -  wywietlenie wszystkich rekordw
     w - zapisanie rekrodu
     d - usunicie rekordu
     x - usunicie wszystkich rekordw
EOF
}

sub readdb  {
     my $keyname  =  getkey();
     if (exists $dbm{"$keyname"})  {
        print "Element  '$keyname' ma warto  $dbm{$keyname}\n";
     }  else  {
        print "Ten element nie istnieje. \n";
     }
}
sub listdb  {
     foreach  (sort  keys(%dbm))  {
        print  "$_  =>  $dbm{$_}\n";
     }
}

sub writedb  {
     my $keyname  =  getkey();
     my $keyval  =  getval();

     if (exists $dbm{"$keyname"})  {
        print "Element  ju istnieje\n";
     }  else  {
        $dbm{$keyname}=$keyval;
     }
}

sub deletedb  {
     my $keyname  =  getkey();

     if (exists $dbm{"$keyname"})  {
        print "Spowoduje to usunicie wpisu $keyname.";
        delete  $dbm{$keyname}  if besure();
     }
}

sub cleardb  {
     print "Spowoduje to usunicie caej zawartoci bazy danych. \n";
     undef %dbm  if besure();
}

#*** Procedury odczytu  ***#
sub getkey  {
     print  "Podaj nazw klucza:  ";
     chomp($_  =  <STDIN>);
     $_;
}

sub getval  {
     print  "Podaj warto elementu:  ";
     chomp($_  =  <STDIN>);
     $_;
}

sub besure  {
     print  "Czy chcesz kontynuowa (t|n)? ";
     chomp($_  =  <STDIN>);
     /^t/i;
}