#!/usr/bin/perl
#mldbm4.plx
use MLDBM qw(SDBM_File Storable);
use POSIX; 
use warnings;

my  %mldbm;
my  $mldb_file="mldbmdemo.dbm";

tie  (%mldbm,  'MLDBM',  $mldb_file,  O_CREAT|O_RDWR,   0644);

unless (tied  %mldbm)   {
    print   "Bd podczas otwierania $mldb_file $!. \n";
}   else   {
    #wyma poprzedni zawarto, jeli taka istnieje
    undef  %mldbm;
    $mldbm{'Utworzono'}=localtime;

    #przypisz list anonimow, bezporednio i poprzez kopi
    $mldbm{'ListaAnonimowa'}=[1,2,3,4,"Pi",6,7,8];
    my @list=(9,"Dziesi",11,12,13,14);
    $mldbm{'OryginalnaLista'}=\@list;
    $mldbm{'KopiaListy'}=[  @list  ];
    $mldbm{'LiczbaElementwListy'}=@list;
    $list[0]="Dziewi"; #nie zmienia wartoci zmiennej 'OryginalnaLista'

    #przypisz anonimow tablic asocjacyjn, bezporednio i poprzez kopi
    $mldbm{'TablicaAnonimowa'}={Jeden=>'1',Dwa=>'2',Trzy=>'3'};
    my %hash=('Cztery'=>'4', 'Pi'=>'5', 'Sze'=>'6');
    $mldbm{'Oryginalnatablica'}=\%hash;
    $mldbm{'KopiaTablicy'}={  %hash  };
    $mldbm{'LiczbaElementwTablicy'}=keys %hash;
    $hash{Cztery}="IV"; #nie zmienia wartoci zmiennej 'OryginalnaTablica'

    #przypisz losowo wybrany klucz i warto
    $mldbm{rand()}=rand;

    # bardziej zoone przypisanie
    $mldbm{'TablicaMieszanychZmiennych'}={
        List1=>[1,2,3],
        List2=>[4,5,6],
        String=>"acuch",
        Hash1=>{
                       A=>"a",
                       B=>"b",
                       Hash2=>{
                                 C=>"c",
                       },
        },
        Number=>14.767,
        List3=>[7,8,9],
    };

    #a teraz znw wywietlimy ca zawarto
    foreach  (sort  keys  %mldbm)  {
           print   "$_  =>  $mldbm{$_}\n";
           if  (my $ref=ref  $mldbm{$_})  {
                if  ($ref  eq  'HASH')  {
                      foreach  my $key  (sort  keys  %{  $mldbm{$_} })  {
                              print   "\t$key => =>  $mldbm{$_}{$key}\n";
                      }
                }  else {
                      print   "\t",(join ",",@{ $mldbm{$_} }),"\n"
                };
           }
    }
    untie  %mldbm;
}