#!/usr/bin/perl
# webchecker.plx
use warnings;
use strict;
my %odwiedzone;

print "Program sprawdzajcy strony, wersja 1.\n";
die "Sposb wywoania: $0 <strona startowa> <adres witryny>\n"
   unless @ARGV ==2;
my ($start, $adres_bazowy) = @ARGV;
$adres_bazowy .= "/" unless $adres_bazowy=~m|/$|;

die "$start wydaje si nie nalee do witryny $adres_bazowy\n"
   unless na_naszej_witrynie($start);
przeszukaj ($start);

sub przeszukaj {
   my $url = shift;
   $url =~ s|/$|/index.html|;
   return if $odwiedzone{$url}++ ;       #zapobiegamy cyklicznemu zaptleniu
   my $strona = pobierz($url);
   if ($strona) {
      print "cze poprawne : $url\n";
   } else {
      print "cze uszkodzone : $url\n";
      return;                       #warunek zakoczenia: jeli cze uszkodzone
   }
   return unless na_naszej_witrynie($url);    #warunek zakoczenia: witryna zewntrzna
   my @lacza = pobierz_lacza($strona,$url);
   return unless @lacza;                      #warunek zakoczenia: brak cz
   for my $lacze (@lacza) {
      przeszukaj($lacze);          #Rekurencja
   }
}

sub na_naszej_witrynie {
   my $url = shift;
   return index($url, $adres_bazowy) == 0;
}

sub pobierz {
   my $co = shift;
   sleep 5; # bd grzeczny
   return `lynx source $co`;
}

sub pobierz_lacza {
   my ($strona, $url) = @_;
   my $katalog = $url;
   my @lacza;
   $katalog =~ s|(.*)/.*?$|$1|;
   for (@lacza = ($strona=~/<A HREF=["']?([^\s"'>]+)["']?/gi)) {
      $_ = $adres_bazowy.$_ if s|^/||;
      $_ = $katalog."/".$_ if  !/^(ht|f)tp:/;
   }
   return @lacza;
}
