#!/usr/bin/perl
# chess.plx
use warnings;
use strict;

my @chessboard;
my @back = qw(W S L K Kr L S W);
for (0..7) {
   $chessboard[0]->[$_] = "B" . $back[$_]; # Drugi rzd biaych figur
   $chessboard[1]->[$_] = "BP";            # Biae Piony
   $chessboard[6]->[$_] = "CP";            # Czarne Piony
   $chessboard[7]->[$_] = "C" . $back[$_]; # Drugi rzd czarnych figur

}

while (1) {
# Wywietl tablic
   for my $i (reverse (0..7)) { # Rzd
       for my $j (0..7) {       # Kolumna
          if (defined $chessboard[$i]->[$j]) {
            print $chessboard[$i]->[$j];
          } elsif ( ($i %2) == ($j %2) ) {
             print "..";
          } else {
             print "  ";
          }
         print " ";   
      }
      print "\n";     
   }

   print "\nPole poczatkowe [x,y]: ";
   my $move = <>;
   last unless ($move =~ /^\s*([1-8]),([1-8])/);
   my $startx = $1-1; my $starty = $2-1;
      
   unless (defined $chessboard[$starty]->[$startx]) {
      print "Na tym polu nie ma figury!\n";
      next;
   }
   print "\nPole docelowe [x,y]: ";
   $move = <>;
   last unless ($move =~ /([1-8]),([1-8])/);
   my $endx = $1-1; my $endy = $2-1;

   # Przesun figury
   $chessboard[$endy]->[$endx] = $chessboard[$starty]->[$startx];
   # Usun figure ze starego pola
   undef $chessboard[$starty]->[$startx];
}
