package Apache::CookieStuff; 
# nazwa pliku: CookieStuff.pm 
 
use strict; 
use Apache::Cookie; 
use Apache::File; 
 
# Importuj sta?e dla mod_perl 
use Apache::Constants qw(OK DECLINED NOT_FOUND); 
 
sub handler 
{ 
    # Pobierz obiekt zadania Apache 
    my $r = shift; 
 
    # Obsluguj tylko pliki typu text/html  
    return DECLINED unless ($r->content_type eq "text/html"); 
 
    # ------------------------------------------------------------ 
    # Pobierz cookie last_visited, jesli istnieje  
 
    my %cookies = fetch Apache::Cookie; 
 
    my $last_visited; 
 
    if (exists $cookies{'last_visited'}) 
    { 
        $last_visited = $cookies{'last_visited'}->value; 
        $r->log_error("Got 'last_visited' cookie => '$last_visited'"); 
    } 
    else 
    { 
        $r->log_error("No 'last_visited' cookie"); 
    } 
 
    # ------------------------------------------------------------ 
    # Wyslij nowe cookie last_visited  
 
    my $current_time = localtime; 
 
    my $cookie = Apache::Cookie->new($r,  
                                     -name => 'last_visited', 
                                     -value => $current_time); 
 
    $r->log_error("Setting last_visited to '$current_time'"); 
 
    $cookie->bake(); 
 
    # ------------------------------------------------------------ 
    # Wyslij odpowiedni naglowek MIME 
    $r->send_http_header(); 
 
    # Wyslij plik 
    my $FILE; 
    if (my $FILE = Apache::File->new($r->filename)) 
    { 
        # Wczytaj pliki od razu 
        undef $/; 
 
        # Pobierz zawartosc pliku 
        my ($contents) = (<$FILE>); 
 
        my $footer = "<hr>\n<p>Last visited: '$last_visited'</p>\n" 
            if $last_visited; 
 
        # Dodaj stopke u dolu strony 
        $contents =~ s|</body>|$footer\n</body>|i; 
 
        # Wyswietl zawartosc 
        $r->print($contents); 
 
        # Zamknij uchwyt pliku 
        $FILE->close; 
 
        # Poinformuj, ze wszystko poszlo dobrze 
        return OK; 
    } 
    # zwroc odpowiedni komunikat o bledzie 
    else 
    { 
        return NOT_FOUND; 
    } 
} 
 
1; 
