#!/usr/bin/perl -T 
# nazwa pliku: save-personalization.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
use Digest::MD5 qw(md5_hex); 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $dbusername = 'reuven'; 
my $dbpassword = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $dbusername, $dbpassword, 
                       { 
                        'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
$dbh->trace(3, "/tmp/dbi-trace.txt"); 
 
# Wyliczamy wartosc MD5 specjalnej (sekretnej) frazy i identyfikatora, 
# utrudni to podszywanie sie pod innego uzytkownika. 
my $secret_md5_phrase = 'coreperl-personalization'; 
 
# ------------------------------------------------------------ 
# Pobierz dane od uzytkownika lub zakoncz dzialanie  
# ------------------------------------------------------------ 
 
my $first_name = $query->param("first_name") ||  
    die "No first name provided."; 
my $last_name = $query->param("last_name") ||  
    die "No last name provided."; 
my $background_color = $query->param("background_color") || 
    die "No background color provided."; 
($background_color =~ /^\#[a-z0-9]{6}$/i) ||  
    die qq{Background color "$background_color" has non-hex digits!}; 
my $email = $query->param("email") || 
    die "No e-mail address provided."; 
my $password = $query->param("password") || 
    die "No password provided."; 
my $birthday = $query->param("birthday") || 
    die "No birthday provided."; 
 
my $oid_md5 = 'dummy md5 value'; 
 
# ------------------------------------------------------------ 
# Wstaw nowy wiersz, jesli takiego adresu e-mail nie ma w tabeli. 
# ------------------------------------------------------------ 

# Rozpocznij nowa transakcje, ktora zakonczy commit() lub rollback() 
$dbh->begin_work(); 
 
my $sql = "SELECT id FROM UserInfo "; 
$sql .= "  WHERE email = ? "; 
 
my $sth = $dbh->prepare($sql); 
$sth->execute($email); 
 
# Jesli jest juz taki adres e-mail, zakoncz sygnalizujac blad. 
die "This e-mail address has already been taken! " 
    if ($sth->fetchrow_arrayref); 
 
# Zakoncz te instrukcje 
$sth->finish; 
 
# Wstaw nowy wiersz 
$sql = "INSERT INTO UserInfo "; 
$sql   .= "(oid_md5, first_name, last_name, email, "; 
$sql   .= " bgcolor, birthday, password) "; 
$sql   .= "VALUES (?, ?, ?, ?, ?, ?, ?) "; 
 
my $insert_sth = $dbh->prepare($sql); 
$insert_sth->execute($oid_md5, $first_name, $last_name, $email, 
                     $background_color, $birthday, $password); 
 
# Pobierz identyfikator wstawionego wiersza 
my $new_row_oid = $insert_sth->{pg_oid_status}; 
 
# Zakonczylismy prace z tym zapytaniem 
$insert_sth->finish(); 
 
# ------------------------------------------------------------ 
# Przygotuj zaszyfrowany identyfikator powstaly z  
# identyfikatora OID oraz sekretnej frazy,  
# ------------------------------------------------------------ 
$oid_md5 = md5_hex($new_row_oid . $secret_md5_phrase); 
 
# Teraz ustaw zaszyfrowany identyfikator  
$sql  = "UPDATE UserInfo "; 
$sql .= "SET oid_md5 = ? "; 
$sql .= "WHERE oid = ? "; 
 
# Wykonaj zapytanie 
my $rows_modified = $dbh->do($sql, undef, $oid_md5, $new_row_oid); 

# Jesli nie zostanie zmieniony zaden wiersz, trzeba zasygnalizowac 
# uzytkownikowi blad  
if ($rows_modified eq "0E0") 
{ 
    $dbh->rollback(); 
 
    # Wyslij odpowiedni naglowek MIME wraz z cookie  
    print $query->header(-type => "text/html"); 
 
    # Wyswietl komunikat o niepowodzeniu 
    print $query->start_html(-title => "Personalization failed!"); 
    print h1('Personalization failed!'); 
    print p('Sorry, but we could not register you.  Please try again.'); 
    print $query->end_html; 
} 
 
# Zatwierdz transakcje, ustaw cookie w przegladarce uzytkownika  
# i wyslij informacje o sukcesie  
else 
{ 
    $dbh->commit(); 
 
    # ------------------------------------------------------------ 
    # Zapisz w cookie przegladarki uzytkownika jego podpis MD5 
    # ------------------------------------------------------------ 
    my $cookie = $query->cookie(-name => "userid", 
                                -value => $oid_md5, 
                                -expires => "+1y"); 
 
    # Wyslij odpowiedni naglowek MIME wraz z cookie 
    print $query->header(-type => "text/html", 
                         -cookie => $cookie); 
 
    # ------------------------------------------------------------ 
    # Teraz mozna wyslac odpowiedz HTML 
    # ------------------------------------------------------------ 
    print $query->start_html(-title => "Personalization complete!", 
                             -bgcolor => $background_color); 
    print h1("Personalization complete!"); 
    print p("Welcome to our site, $first_name $last_name!"); 
    print $query->end_html; 
} 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
