#!/usr/bin/perl -T 
# nazwa pliku: restore-cookie.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser);
use DBI; 
 
# Zadeklaruj zmienna dla identyfikatora uzytkownika  
my $oid_md5; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $dbusername = 'reuven'; 
my $dbpassword = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $dbusername, $dbpassword, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
$dbh->trace(3, "/tmp/dbi-trace.txt"); 
 
# Pobierz wprowadzony adres e-mail i haslo 
my $email = $query->param("email"); 
my $password = $query->param("password"); 
 
# Upewnij sie, ze obie informacje zostaly podane 
unless ($email and $password) 
{ 
    print $query->header("text/html"); 
    print $query->start_html(-title => "Missing information"); 
 
    print h1("Missing information"), 
        p("Your e-mail address and password are required", 
          "in order to restore the cookie.  Please try again."); 
    print $query->end_html; 
    exit; 
} 
 
# Utworz zapytanie 
my $sql = "SELECT oid_md5 "; 
$sql   .= "FROM UserInfo "; 
$sql   .= "WHERE email = ? "; 
$sql   .= "AND password = ?"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($email, $password); 

# Pobierz zwrocony wiersz, jesli znalazles odpowiedni  
($oid_md5) = $sth->fetchrow_array; 
warn "oid_md5 = '$oid_md5'"; 
 
$sth->finish(); 
 
# Jesli jest taki identyfikator, przywroc cookie uzytkownika  
if ($oid_md5) 
{ 
    # Utworz cookie 
    my $cookie = $query->cookie(-name => "userid", 
                                -value => $oid_md5, 
                                -path => "/cgi-bin", 
                                -expires => "+1y"); 
 
    # Wyslij odpowiedni naglowek MIME wraz z cookie  
    print $query->header(-type => "text/html", 
                         -cookie => $cookie); 
 
    print $query->start_html(-title => "Success!"); 
 
    print h1("Success!"), 
        p("We were able to restore your registration cookie."), 
            p("Go to your",  
              a({href => "/cgi-bin/personal-db-homepage.pl"},  
                "personal home page")); 
} 
else 
{ 
    print $query->header(-type => "text/html"); 
    print $query->start_html(-title => "Bad email or password"); 
 
    print h1("Bad email or password"), 
        p("Sorry, but the entered email address and password", 
          "were not in our records."), 
              p("Try again, or",  
                a({href => "/personalize-form.html"}, 
                  "register.")); 
} 
 
# Zakoncz calosc 
print $query->end_html; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
