#!/usr/bin/perl -T 
# nazwa pliku: read-postcard.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz pocztowke wybrana przez uzytkownika
my $id = $query->param("id") || die "You must provide an ID!"; 
 
# Utworz zapytanie 
my $sql = "SELECT sender_name, sender_email, "; 
$sql .= "recipient_name, recipient_email, message "; 
$sql .= "FROM Postcards "; 
$sql .= "WHERE oid_md5 = ?"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($id); 
 
# Wyslij odpowiedni naglowek MIME  
print $query->header("text/html"); 
 
# Pobierz wyniki z wiersza 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    # Pobierz wartosc z wiersza 
    my ($sender_name, $sender_email, $recipient_name,  
        $recipient_email, $message) = @$rowref; 
 
    print $query->start_html(-title =>  
                             "Postcard from $sender_name ($sender_email)"); 
    print h1("Postcard from $sender_name ($sender_email)"), 
        p("You have a postcard, $recipient_name ($recipient_email)", 
          pre($message)); 
} 
 
if ($sth->rows == 0) 
{ 
    print $query->start_html(-title => "No postcard found"); 
    print h1("No postcard found"), 
        p("No postcard was found with id '$id'.  Please try again."); 
} 
 
print $query->end_html; 
 
# Zakoncz instrukcje 
$sth->finish; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
