#!/usr/bin/perl -T 
# nazwa pliku: lookup-range.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz symbol spolki interesujacej uzytkownika 
my $symbol = $query->param("symbol") ||  
    die "No symbol provided; try again."; 
 
# Wszystkie symbole sa wielkimi literami, trzeba je wiec przetlumaczyc  
$symbol = "\U$symbol"; 
 
# Pobierz date startowa i koncowa 
my $start_date = $query->param("start_date"); 
my $end_date = $query->param("end_date"); 
 
# Utworz zapytanie 
my $sql =  "SELECT V.stock_value, V.value_timestamp "; 
$sql .= "  FROM StockSymbols S, StockValues V "; 
$sql .= "  WHERE S.symbol = ? "; 
$sql .= "    AND S.symbol_id = V.symbol_id "; 
 
my @placeholders = (); 
if ($start_date) 
{ 
    $sql .= "AND V.value_timestamp >= ? "; 
    push @placeholders, $start_date; 
} 
 
if ($end_date) 
{
    $sql .= "AND V.value_timestamp <= ? "; 
    push @placeholders, $end_date; 
} 
 
$sql .= "ORDER BY V.value_timestamp"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($symbol, @placeholders); 
 
# Wyslij wyniki do przegladarki uzytkownika 
print $query->header("text/html"); 
print $query->start_html(-title => "Values for $symbol"); 
 
print h1("Values for $symbol"); 
 
print '<table border="1">'; 
print th(['Date', 'Value']); 
 
# Pobierz wyniki z wiersza tabeli 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    my ($value,$date) = @$rowref; 
    print Tr(td([$date, $value])); 
} 
 
print "</table>\n"; 
 
# Brak wynikow?  Cos jest nie tak! 
if (! $sth->rows()) 
{ 
    print p("No results were available.  Either no data has been", 
            "entered for", b($symbol), "during this period, ", 
            "or the symbol was misspelled."); 
} 
 
print $query->end_html(); 
 
# Zakoncz instrukcje 
$sth->finish; 
 
# Zakoncz polaczenie z baza danych 
$dbh->disconnect; 
