#!/usr/bin/perl -T 
# nazwa pliku: graph-range.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
use PNGgraph::linespoints; 
 
# Zadeklaruj tablice wartosci i dat 
my (@values, @dates); 
 
# Przygotuj nowa instancje klasy CGI 
my $query = new CGI;
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz symbol, ktory interesuje uzytkownika 
my $symbol = $query->param("symbol") ||  
    die "No symbol provided; try again."; 
 
# Symbole sa duzymi literami, wiec przetlumacz je  
$symbol = "\U$symbol"; 
 
# Pobierz startowa i koncowa date 
my $start_date = $query->param("start_date"); 
my $end_date = $query->param("end_date"); 
 
# Utworz zapytanie 
my $sql =  "SELECT V.stock_value, V.value_timestamp "; 
$sql .= "  FROM StockSymbols S, StockValues V "; 
$sql .= "  WHERE S.symbol = ? "; 
$sql .= "    AND S.symbol_id = V.symbol_id "; 
 
my @placeholders = (); 
if ($start_date) 
{ 
    $sql .= "AND V.value_timestamp >= ? "; 
    push @placeholders, $start_date; 
} 
 
if ($end_date) 
{ 
    $sql .= "AND V.value_timestamp <= ? "; 
    push @placeholders, $end_date; 
} 
 
$sql .= "ORDER BY V.value_timestamp"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($symbol, @placeholders); 

# Utworz instancje klasy wykresu PNGgraph::linespoints 
my $graph = new PNGgraph::linespoints(500,500); 
 
# Pobierz wyniki z wiersza tabeli 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    # Pobierz wartosc z wiersza 
    my ($value,$date) = @$rowref; 
 
    # Dodaj wartosc i odpowiadajaca jej date do tabel  
    push @values, $value; 
    push @dates, $date; 
} 
 
# Jesli baza nic nie zwrocila, przygotuj komunikat o bledzie  
if ($sth->rows() == 0) 
{ 
    print $query->header("text/html"); 
    print $query->start_html(-title => "No data available"); 
    print h1("No data available"), 
        p("Sorry, but no data is available for $symbol", 
          "during this period."); 
    print $query->end_html; 
    exit; 
} 
 
# Zdefiniuj dane dla wykresu 
my @data = (\@dates, \@values); 
 
# Ustaw pare parametrow wykresu 
$graph->set(x_label => 'Dates', 
            y_label => 'Stock prices', 
            title => "Stock prices for $symbol"); 
 
# Wyslij odpowiedni naglowek MIME  
print $query->header("image/png"); 
 
# Przygotuj wykres i wyslij go do przegladarki uzytkownika  
print $graph->plot(\@data); 
 
# Zakoncz te instrukcje 
$sth->finish; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
