#!/usr/bin/perl -T 
# nazwa pliku: download.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard);               # importuj procedury HTML  
use CGI::Carp qw(fatalsToBrowser);   # przesylaj bledy przegladarce 
use MLDBM qw(Tie::DB_Lock Storable); # Uzyj MLDBM wraz z blokowaniem 
use Digest::MD5 qw(md5_hex);         # Uzyj MD5 do szyfrowania hasel 
 
$ENV{PATH} = ''; 
 
# Wlacz automatyczne oproznianie bufora 
$| = 1; 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Plik z informacjami o uzytkowniku 
my $userinfo = "/web/users.dbm"; 
 
# ------------------------------------------------------------ 
# Sprawdzanie informacji uwierzytelniajacych uzytkownika
# ------------------------------------------------------------ 
 
my %users; 
tie %users, "MLDBM", $userinfo, 'r' or die "Error tying \%user: $! "; 
 
my $username = $query->param('username'); 
my $password = $query->param('password'); 
 
if ((exists $users{$username}) and  
    ($users{$username}->{password} eq md5_hex($password))) { 
    # Pobierz nazwe pliku 
    my $form_file = $query->param('file'); 
 
    # Usun z poczatku nazwy znaki / i .  
    $form_file =~ s|^[/.]+||g; 
 
    # Otworz plik 
    open FILE, "/downloads/$form_file" or 
        die "Cannot open '$form_file' for reading: $! "; 
 
    # Wyslij naglowek sygnalizujacy dane binarne 
    print $query->header("application/octet-stream"); 
 
    # Teraz wyslij plik 
    print while (<FILE>); 
 
    # Zamknij plik i zakoncz  
    close FILE; 
} 
 
# ------------------------------------------------------------ 
# Jesli uzytkownik nie jest zarejestrowany lub haslo nie pasuje, 
# wyslij uzytkownikowi komunikat o bledzie. 
# ------------------------------------------------------------ 
else 
{ 
    print $query->header("text/html"); 
 
    print $query->start_html(-title => "Bad user name/password combination"); 
    print h1("Bad user name/password combination"); 
    print p("Sorry, but this user name/password combination does not exist. "); 
    print $query->end_html; 
} 
 
untie %users; 
