#!/usr/bin/perl 
# nazwa pliku: query-title.pl 
 
use strict; 
use warnings; 
use DBI; 
 
print qq{Welcome to the "query title" program.\n\n};
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz tytul od uzytkownika 
print "Enter a search string: "; 
my $target = <>; 
chomp $target; 
 
# Wez w cudzyslow metaznaki SQL  
$target =~ s|%|\\\%|g; 
$target =~ s|_|\\\_|g; 
 
# Przeksztalc lancuch w wyrazenie regularne SQL  
$target = "%$target%"; 
 
# Utworz zapytanie 
my $sql = "SELECT B.isbn, B.title, P.publisher_name, B.num_pages, "; 
$sql .= "      B.pub_date, B.us_dollar_price, A.author_name "; 
$sql .= "FROM Books B, Publishers P, Authors A, BookAuthors BA "; 
$sql .= "WHERE LOWER(B.title) LIKE LOWER(?) "; 
$sql .= "  AND BA.author_id = A.author_id "; 
$sql .= "  AND B.book_id = BA.book_id "; 
$sql .= "  AND B.publisher_id = P.publisher_id "; 
$sql .= "ORDER BY A.author_name "; 
 
# Przygotuj instrukcje 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj instrukcje 
my $success = $sth->execute($target); 
 
if ($success) 
{ 
    my %book = (); 
 
    while (my $rowref = $sth->fetchrow_arrayref) 
    { 
        my ($isbn, $title, $publisher, $pages,  
            $date, $price, $author) = @$rowref; 
 
        # Zachowaj informacje o ksiazce w %book
        $book{$isbn}->{title} = $title; 
        $book{$isbn}->{publisher} = $publisher; 
        $book{$isbn}->{pages} = $pages; 
        $book{$isbn}->{date} = $date; 
        $book{$isbn}->{price} = $price; 
 
        # zajmij sie autorami 
        if ($book{$isbn}->{author}) 
        { 
            $book{$isbn}->{author} .= ", $author"; 
        } 
        else 
        { 
            $book{$isbn}->{author} = "$author"; 
        } 
    } 
 
    # Przejrzyj ksiazki w petli i wyswietl informacje o nich  
    foreach my $isbn  
        (sort {$book{$a}->{title} cmp $book{$b}->{title}} keys %book) 
        { 
            print "\n"; 
            print "$book{$isbn}->{title}\n"; 
            print "-" x length($book{$isbn}->{title}), "\n"; 
 
            print "by $book{$isbn}->{author}\n"; 
            print "ISBN: $isbn\tPublisher: $book{$isbn}->{publisher}\n"; 
            print "Publication date: $book{$isbn}->{date}\t"; 
            print "Price: \$$book{$isbn}->{price}\n"; 
            print "Pages: $book{$isbn}->{pages}\n"; 
        } 
 
    if ($sth->rows == 0) 
    { 
        print "Sorry, no results found.\n"; 
    } 
 
} 
else 
{ 
    print "Error preparing: $DBI::errstr"; 
} 
 
$sth->finish(); 
$dbh->disconnect(); 
