#!/usr/bin/perl 
# nazwa pliku: two-anonymous-pipes.pl 
 
use strict; 
use warnings; 
 
# Utworz potoki 
pipe(PARENT_READ, CHILD_WRITE); 
pipe(CHILD_READ, PARENT_WRITE); 
 
select CHILD_WRITE; $| = 1;  # Automatycznie oprozniaj bufor CHILD_WRITE 
select PARENT_WRITE; $| = 1; # Automatycznie oprozniaj bufor PARENT_READ 
select STDOUT; 
 
# Rozwidlenie! 
my $pid = fork(); 
 
# Upewnij sie, ze rozwidlenie dziala 
die "Cannot fork: $! " unless (defined $pid); 
 
# Potomek pisze do procesu nadrzednego 
if ($pid == 0) 
{ 
    # Zamknij potoki po stronie uzywanej przez proces nadrzedny 
    close PARENT_READ; 
    close PARENT_WRITE; 
 
    # Wyslij wiadomosc do procesu nadrzednego 
    print CHILD_WRITE "This is child $$, saying hello!\n"; 
 
    # Pobierz wiadomosc od procesu nadrzednego 
    my $message = <CHILD_READ>; 
    print "Child received message '$message' from parent\n"; 
 
    # Zawsze zamykaj uchwyty plikow 
    close CHILD_READ or die "Error closing: $! "; 
    close CHILD_WRITE or die "Error closing: $! "; 
 
    exit; 
} 
 
# Proces nadrzedny odczytuje wiadomosc potomka 
else 
{ 
    # Zamknij potoki po stronie uzywanej przez potomka 
    close CHILD_READ; 
    close CHILD_WRITE; 
 
    # Wyslij wiadomosc do procesu potomnego 
    print PARENT_WRITE "This is parent $$, saying hello!\n"; 
 
    # Pobierz wiadomosc od potomka 
    my $message = <PARENT_READ>; 
    print "Parent received message '$message' from child\n"; 
 
    # Zawsze zamykaj uchwyty plikow 
    close PARENT_READ or die "Error closing: $! "; 
    close PARENT_WRITE or die "Error closing: $! "; 
 
    exit; 
} 
