#!/usr/bin/perl 
# nazwa pliku: socketpair.pl 
 
use strict; 
use warnings; 
use Socket; 
 
# Utworz pare dwukierunkowych gniazd 
socketpair(CHILD_TO_PARENT, PARENT_TO_CHILD,  
           AF_UNIX, SOCK_STREAM, PF_UNSPEC) 
    or die "Cannot create socketpair: $! "; 
 
select CHILD_TO_PARENT; $| = 1; 
select PARENT_TO_CHILD; $| = 1; 
select STDOUT; 
 
# Rozwidlenie! 
my $pid = fork(); 
 
# Upewnij sie, ze rozwidlenie dziala 
die "Cannot fork: $! " unless (defined $pid); 
 
# Potomek pisze do procesu nadrzednego 
if ($pid == 0) 
{ 
    # Wyslij wiadomosc do procesu nadrzednego 
    print CHILD_TO_PARENT "This is child $$, saying hello!\n"; 
    close CHILD_TO_PARENT  
        or die "Cannot close CHILD_TO_PARENT: $! "; 
 
    # Pobierz wiadomosc od procesu nadrzednego 
    my $message = <PARENT_TO_CHILD>; 
    print $message; 
    close PARENT_TO_CHILD 
        or die "Cannot close PARENT_TO_CHILD: $! "; 
 
    exit; 
} 
 
# Proces nadrzedny czyta wiadomosc od procesu potomnego 
else 
{ 
    # Wyslij wiadomosc do potomka 
    print PARENT_TO_CHILD "This is parent $$, saying hello!\n"; 
    close PARENT_TO_CHILD  
        or die "Cannot close PARENT_TO_CHILD: $! "; 
 
    # Pobierz wiadomosc od potomka 
    print while (<CHILD_TO_PARENT>); 
    close CHILD_TO_PARENT  
        or die "Cannot close CHILD_TO_PARENT: $! "; 
 
    exit; 
} 
