#!/usr/bin/perl 
# nazwa pliku: sigpipe-demo.pl 
 
use strict; 
use warnings; 
 
# Zainstaluj obs?uge sygnalu SIGPIPE 
$SIG{PIPE} =  
    sub { print "\nProcess $$ caught SIG{PIPE}: $! "; exit;}; 
 
# Utworz potoki 
pipe(READONLY, WRITEONLY); 
 
# Rozwidlenie! 
my $pid = fork(); 
 
# Upewnij sie, ze rozwidlenie dziala 
die "Cannot fork: $! " unless (defined $pid); 
 
# Proces potomny pisze do procesu rodzica 
if ($pid == 0) 
{ 
    # Zamknij uchwyt pliku tylko do odczytu 
    close READONLY; 
 
    my $counter = 1; 
 
    # Nieskonczona petla! 
    while (1) 
    { 
        $counter++; 
        print WRITEONLY "This is child $$, on loop $counter.\n"; 
    } 
 
    # Zamknij uchwyt pliku i poszukaj bledow 
    close WRITEONLY or die "Error closing: $! "; 
 
    exit; 
} 
 
# Proces nadrzedny odczytuje wiadomosc od potomka 
else 
{ 
    # Zamknij uchwyt pliku tylko do zapisu 
    close WRITEONLY; 
 
    # Odczytaj jeden wiersz od potomka 
    my $message = <READONLY>; 
    print $message; 
 
    # Zamknij uchwyt pliku i poszukaj bledow 
    close READONLY or die "Error closing: $! "; 
 
    exit; 
} 
