#!/usr/bin/perl 
# nazwa pliku: multi-socket-server.pl 
 
use strict; 
use warnings; 
use IO::Socket; 
 
# Utworz gniazdo serwera 
my $socket = IO::Socket::INET->new(Proto => "tcp", 
                                   LocalPort => 5555, 
                                   Listen => SOMAXCONN, 
                                   Reuse => 1); 
 
# Zdefiniuj procedure usuwajaca procesy potomne 
sub REAPER 
{ 
    # Ustal, ktore procesy zakonczyly prace i wylacz je po cichu 
    my $which_process = wait; 
 
    # Zainstaluj sie ponownie, jesli dzialamy w wersji 
    # systemu Unix, ktora tego wymaga 
    $SIG{CHLD} = \&REAPER; 
} 
 
# Zainstaluj obsluge sygnalow 
$SIG{CHLD} = \&REAPER; 
 
print STDERR "Starting server...\n"; 
 
# Akceptuj nadchodzace polaczenia 
while (my $client = $socket->accept()) { 
 
    # Rozwidlenie! 
    my $pid = fork(); 
    die "Cannot fork: $! " unless (defined $pid); 
 
    # Tu dziala proces potomny 
    if ($pid == 0) 
    { 
        # Odczytaj jeden wiersz od klienta 
        my $buffer = <$client>; 
 
        print STDERR qq|Received: "$buffer"\n|; 
 
        # Pobiez biezaca date 
        my $date = localtime time; 
 
        # Wyslij informacje do klienta 
        print $client "Hello from the server on $date!\n"; 
 
        # Zamknij gniazdo 
        close $client; 
 
        # Proces potomny musi zakonczyc prace 
        exit; 
    } 
 
    # Proces nadrzedny zamyka gniazdo i czeka na nowe polaczenie 
    close $client; 
} 
 
print STDERR "Shutting down server...\n"; 
