#!/usr/bin/perl
# nazwa pliku: store-mldbm.pl

use strict;
use warnings;
use Fcntl;

# Wskaz, ktory z wewnetrznych mechanizmow bedzie uzywany
use MLDBM qw(DB_File);

# Pobierz argument nazwy pliku
my $file = $ARGV[0] or die "Brak argumentu!";

# Otworz plik DBM 
my %data;
tie %data, "MLDBM", $file, O_RDWR|O_CREAT
    or die "Bd wizania %data: $! ";

# Utworz kilka zmiennych
my $scalar = 100;
my @array = qw(a b c d e);
my %hash = ("z" => 26, "y" => 25, "x" => 24);

# Zachowaj odwolania do tych zmiennych
$data{scalar} = \$scalar;
$data{array} = \@array;
$data{hash} = \%hash;

# Odwiaz tablice asocjacyjna %data, ktora bedzie je przechowywac
untie %data;
