#!/usr/bin/perl
# nazwa pliku: print-db-file.pl

use strict;
use warnings;
use DB_File;

# Pobierz nasz argument nazwy pliku
my $file = $ARGV[0] or die "Brak argumentu!";

# Powiaz %data z plikiem DB_File lub zakoncz dzialanie
my %data = ();
tie %data, "DB_File", $file, O_RDONLY
    or die "Bd wizania %data: $! ";

# Wyswietl kazda z par klucz-wartosc
foreach my $key (sort keys %data)
{
    print "$key => $data{$key}\n";
}
