#!/usr/bin/perl
# nazwa pliku: better-bookshelf.pl

use strict;
use warnings;
use Book;

my @shelf = ();

# Plik dzielony znakami Tab, zawierajacy informacje o ksiazce 
my $file = '/tmp/books';

open BOOKS, $file or die "Nie mona czyat '$file': $! ";

while (<BOOKS>)
{
    # Usun z konca znak newline
    chomp;

    # Get the book info
    my @book_info = split /\t/, $_;

    # Zmien informacje o ksiazce w nowa instancje klasy Book
    my $new_book = new Book(@book_info);

    if (defined $new_book)
    {
        push @shelf, $new_book;
    }
    else
    {
        print STDERR "Ostrzaenie: Bd w linii $. of '$file'.\n";
    }
}

close BOOKS; 

# Wyswietl tytuly posortowane alfabetycznie
foreach my $book (sort {$a->get_title cmp $b->get_title} @shelf)
{
    print $book->get_title, "\n";
}
