package Apache::IgnoreCaps; 
# nazwa pliku: IgnoreCaps.pm 
 
use strict; 
use Apache::File; 
use File::Basename; 
 
# Importuj stale dla mod_perl 
use Apache::Constants qw(OK NOT_FOUND); 
 
sub handler 
{ 
    # Pobierz obiekt zadania Apache 
    my $r = shift; 
 
    # Pobierz nazwe pliku 
    my $filename = $r->filename; 
 
    # Jesli nie ma pliku o tej nazwie, przejrzyj 
    # inne pliki w katalogu, szukajac pliku o tej samej 
    # nazwie, ale innej wielkosci liter. Jesli znajdziesz 
    # taki plik, zakoncz poszukiwania  
 
    if (! -e $filename) 
    { 
        my $dirname = dirname($filename); 
 
        if (opendir DIR, $dirname) 
        { 
            # Poszukaj pliku w katalogu, ktorego nazwa  
            # bedzie pasowac, jesli zignorowac wielkosc liter 
            my @matches =  
                grep { lc(basename($filename)) eq lc($_) }  
                    readdir(DIR); 
 
            # Jesli nic nie znajdziesz, poddaj sie 
            unless (@matches) 
            { 
                $r->log_error("[Apache::IgnoreCaps]", 
                              "No matches for $filename"); 
                return NOT_FOUND; 
            } 
 
            # Pobierz pierwsze dopasowanie 
            $filename = $dirname . "/" . $matches[0]; 
 
            # Zakoncz poszukiwania w tym katalogu 
            closedir DIR; 
        } 
 
        # Jesli nie mozna otworzyc katalogu, nie probuj 
        # go otworzyc, tylko zapisz informacje, 
        # ze pojawil sie blad 
        else 
        { 
            $r->log_error("Apache::IgnoreCaps cannot", 
                          qq{open dir "$dirname": $! }); 
            return NOT_FOUND; 
        } 
    } 
 
    # Wyslij odpowiedni naglowek MIME 
    $r->send_http_header; 
 
    # Wyslij plik 
    my $FILE; 
    if ($FILE = Apache::File->new($filename)) 
    { 
        # Wyslij zawartosc pliku 
        $r->print($_) while (<$FILE>); 
 
        # Zamknij uchwyt pliku 
        $FILE->close; 
 
        return OK; 
    } 
    # Zwroc odpowiedni komunikat o bledzie 
    else 
    { 
        $r->log_error("[Apache::IgnoreCaps] "); 
        $r->log_error(qq{Error opening file "$filename": $! }); 
        return NOT_FOUND; 
    } 
 
    return OK; 
} 
 
1; 
