package Apache::HeaderFooter;
# nazwa pliku: HeaderFooter.pm 
 
use strict; 
use Apache::File; 
 
# Importuj stale dla potrzeb mod_perl 
use Apache::Constants qw(OK DECLINED NOT_FOUND); 
 
sub handler 
{ 
    # Pobierz obiekt zadania Apache 
    my $r = shift; 
 
    # Obsluguj tylko pliki typu text/html
    return DECLINED unless ($r->content_type eq "text/html"); 
 
    # Wyslij odpowiedni naglowek MIME  
    $r->send_http_header; 
 
    # Wyslij plik 
 
    my $FILE; 
    if (my $FILE = Apache::File->new($r->filename)) 
    { 
        # Wczytaj naraz pliki 
        undef $/; 
 
        # Pobierz zawartosc pliku 
        my ($contents) = (<$FILE>); 
 
        # Zdefiniuj naglowek i stopke 
        my $header = $r->dir_config("header-text") || 
            "<!-- Default header -->\n"; 
        my $footer = $r->dir_config("footer-text") || 
            "<!-- Default footer -->\n"; 
 
        # Dodaj naglowek u gory 
        $contents =~ s|(<Body.*?>)|$1\n$header|i; 
 
        # A stopke na dole 
        $contents =~ s|</Body>|$footer\n</Body>|i; 
 
        # Wyswietl zawartosc 
        $r->print($contents); 
 
        # Zamknij uchwyt pliku 
        $FILE->close; 
 
        # Poinformuj, ze wszystko poszlo dobrze 
        return OK; 
    } 
    # Przygotuj odpowiedni komunikat o bledzie 
    else 
    { 
        return NOT_FOUND; 
    } 
} 
 
1; 
