#!/usr/bin/perl -T 
# nazwa pliku: personal-db-homepage.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
 
# Zadeklaruj pare zmiennych uzywanych w programie 
my $first_name; 
my $last_name; 
my $bgcolor; 
my $today_is_birthday; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz podpis MD5 z przegladarki uzytkownika 
my $oid_md5 = $query->cookie(-name => "userid"); 
 
# Wyslij odpowiedni naglowek MIME 
print $query->header(-type => "text/html"); 
 
# Jesli znajdziesz identyfikator uzytkownika, pobierz  
# z bazy danych informacje umozliwiajace personalizacje 
if ($oid_md5) 
{ 
    # Utworz zapytanie 
    my $sql = "SELECT first_name, last_name, bgcolor, "; 
    $sql   .= "( to_char(birthday, 'Day Mon D') = "; 
    $sql   .= "  to_char(CURRENT_DATE, 'Day Mon D')) as today_is_birthday "; 
    $sql   .= "FROM UserInfo ";
    $sql   .= "WHERE oid_md5 = ?"; 
 
    # Przygotuj zapytanie 
    my $sth = $dbh->prepare($sql); 
 
    # Wykonaj zapytanie 
    $sth->execute($oid_md5); 
 
    # Pobierz dane tego uzytkownika 
    while (my @row = $sth->fetchrow) 
    { 
        ($first_name, $last_name,  
         $bgcolor, $today_is_birthday) = @row; 
    } 
 
    # Wyswietl uzytkownikowi strone "witamy ponownie" ("welcome back") 
    print $query->start_html(-title => "Welcome back!", 
                             -bgcolor => $bgcolor); 
    print h1("Welcome back!"), 
        p("You are: $first_name $last_name"); 
 
    # Zloz uzytkownikowi zyczenia, jesli dzis sa jego urodziny 
    if ($today_is_birthday) 
    { 
        print p(b("Happy birthday!")); 
    } 
 
    # Zakoncz te instrukcje SQL 
    $sth->finish; 
} 
 
# W przeciwnym razie powitaj go w witrynie i skieruj do  
# strony zbierajacej dane uzytkownikow 
else 
{ 
    print $query->start_html(-title => "Welcome!"); 
    print h1("Welcome!"), 
        p("You can personalize the site by going to", 
          a({href => "/personalize-form.html"}, "this page"), "."), 
              p("Enjoy!"); 
} 
print $query->end_html; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
