#!/usr/bin/perl -T 
# nazwa pliku: lookup.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz symbol, ktorego potrzebuje uzytkownik 
my $symbol = $query->param("symbol") ||  
    die "No symbol provided; try again."; 
 
#Wszystkie symbole spolek sa wielkimi literami, wiec trzeba  
# je przetlumaczyc  
$symbol = "\U$symbol"; 

# Pobierz z bazy danych biezaca wartosc kursu dla  
# danego symbolu spolki 
my $sql =  "SELECT V.stock_value, V.value_timestamp "; 
   $sql .= " FROM StockSymbols S, StockValues V "; 
   $sql .= "WHERE S.symbol = ? "; 
   $sql .= "  AND S.symbol_id = V.symbol_id "; 
   $sql .= "ORDER BY V.value_timestamp DESC "; 
   $sql .= "LIMIT 1"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($symbol); 
 
# Oczekujemy tylko jednego wiersza, wiec nie potrzeba nam petli while  
my ($value, $timestamp) = $sth->fetchrow_array(); 
 
# Teraz przygotuj dane wyjsciowe 
print $query->header("text/html"); 
 
# Informuj o sukcesie 
if ($value and $timestamp) 
{ 
print $query->start_html(-title => "Value for '$symbol'"); 
print h1("Value for '$symbol'"), 
    p("The value is $value (last updated at $timestamp)."); 
} 
 
# Informuj o niepowodzeniu 
else 
{ 
    print $query->start_html(-title => "No value for '$symbol'"); 
    print h1("No value for '$symbol'"), 
        p("No value was available for the stock with", 
          "a value of $symbol.  Perhaps you spelled it wrong?"); 
} 
 
print $query->end_html; 
 
# Zakoncz instrukcje 
$sth->finish; 
 
# Zakoncz polaczenie z baza danych 
$dbh->disconnect; 
