#!/usr/bin/perl -T
# nazwa pliku: edit-profile.pl

use strict;
use warnings;
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);
use DBI;

# ------------------------------------------------------------
# Przygotuj zmienne uzywane w programie
# ------------------------------------------------------------
my ($first_name, $last_name, $bgcolor, $birthday, $email, $password);


my %colors = ("#000000" => "Black", "#0000FF" => "Blue",  
              "#00FF00" => "Green", "#FF0000" => "Red",  
              "#FFFFFF" => "White"); 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Wyslij odpowiedni naglowek MIME  
print $query->header(-type => "text/html"); 
 
# Polacz sie z baza danych 
my $dbusername = 'reuven'; 
my $dbpassword = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $dbusername, $dbpassword, 
                       { 
                        'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz identyfikator uzytkownika z cookie 
my $oid_md5 = $query->cookie(-name => "userid"); 
 
# Upewnij sie, ze uzytkownik ma cookie 
die "You do not have a user ID! Register or restore your cookie." 
    unless $oid_md5; 
 
# ------------------------------------------------------------ 
# Jesli uruchomiony metoda POST, program aktualizuje wiersz  
# uzytkownika podanymi wartosciami
# ------------------------------------------------------------ 
 
if ($query->request_method eq "POST") 
{ 
    my @pairs; 
 
    my $sql = "UPDATE UserInfo "; 
    $sql   .= "   SET first_name = ?,       last_name = ?, "; 
    $sql   .= "       bgcolor = ?, birthday = ?, "; 
    $sql   .= "       email = ? ,           password = ? "; 
    $sql   .= "WHERE  oid_md5 = ?"; 
 
    # Przygotuj zapytanie 
    my $sth = $dbh->prepare($sql); 
 
    # Wykonaj zapytanie 
    $sth->execute($query->param("first_name"),
                  $query->param("last_name"), 
                  $query->param("bgcolor"), 
                  $query->param("birthday"), 
                  $query->param("email"), 
                  $query->param("password"), 
                  $oid_md5); 
} 
 
# ------------------------------------------------------------ 
# Niezaleznie, czy uruchamiany z pomoca POST czy GET, program 
# musi pobrac informacje o uzytkowniku z bazy danych 
# korzystajac z zapytania SELECT. 
# ------------------------------------------------------------ 
 
# Utworz zapytanie 
my $sql = "SELECT first_name, last_name, "; 
$sql   .= " bgcolor, birthday, email, password "; 
$sql   .= "FROM UserInfo "; 
$sql   .= "WHERE oid_md5 = ?"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($oid_md5); 
 
# Pobierz dane na temat tego uzytkownika 
while (my @row = $sth->fetchrow) 
{
    ($first_name, $last_name, $bgcolor,  
     $birthday, $email, $password) = @row; 
} 
 
$sth->finish; 
 
# Wyswietl formularz HTML 
print $query->start_html(-title => "Edit your profile"); 
print h1("Edit your profile"); 
 
# Niech formularz wskazuje do tego programu 
print '<Form method="POST" action="', $query->script_name, '">', "\n\n"; 
 
print "<Table>\n"; 
 
# Przygotuj pola tekstowe korzystajac z funkcji modulu CGI.pm 
print
    TR(td(p("First name")), 
       td(textfield({name => "first_name", value => $first_name}))), 
    TR(td(p("Last name")), 
       td(textfield({name => "last_name", value => $last_name}))), 
    TR(td(p("E-mail address")), 
       td(textfield({name => "email", value => $email}))), 
    TR(td(p("Birthday")), 
       td(textfield({name => "birthday", value => $birthday}))), 
    TR(td(p("Password")), 
       td(textfield({name => "password", value => $password}))); 
 
# Wyswietl liste dostepnych kolorow tla 
print TR(td(p("Background color")), 
         td(popup_menu({-name => "bgcolor", 
                        -values => [keys %colors], 
                        -default => $bgcolor, 
                        -labels => \%colors}))); 
 
print "</Table>\n"; 
 
# Przygotuj przycisk "zatwierdzenia" ("submit") 
print '<P><input type="submit" value="Save settings"></P>', "\n"; 
print "</Form>\n"; 
 
print $query->end_html; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
