#!/usr/bin/perl -T 
# nazwa pliku: register.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard);               # importuj procedury HTML  
use MLDBM qw(Tie::DB_Lock Storable); # modul MLDBM z blokowaniem 
use Digest::MD5 qw(md5_hex);         # Algorytm MD5 do szyfrowania hasel 
 
# Wlacz automatyczne oproznianie bufora 
$| = 1; 
 
# Przypisz parametrom opisowe nazwy dla komunikatow o bledach 
my %parameters = ("username" => "Your username", 
                  "email" => "Your e-mail address", 
                  "password" => "Your password"); 
 
# Gdzie przechowywany bedzie plik z informacjami o uzytkownikach? 
my $userinfo = "/web/users.dbm"; 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Wyslij naglowek MIME  
print $query->header("text/html"); 
 
# ------------------------------------------------------------ 
# Test sprawdzajacy, czy kazdy parametr ma jakas wartosc 
# ------------------------------------------------------------ 
my $error_message; 
foreach my $parameter_name (sort keys %parameters) 
{ 
    $error_message .= li($parameters{$parameter_name}) 
        unless $query->param($parameter_name); 
} 
 
# Jesli zmienna $error_message jest zdefiniowana,  
# powiedz uzytkownikowi, czego brakuje  
if ($error_message) 
{ 
    print $query->start_html(-title => "Missing information!"); 
    print h1("Missing information");
    print p("You were missing the following required fields", 
            "from your form:"); 
    print ol($error_message); 
    print $query->end_html; 
    exit; 
} 
 
# ------------------------------------------------------------ 
# Zapisz informacje w pliku DBM, jesli mamy nowego uzytkownika  
# ------------------------------------------------------------ 
my %users; 
tie %users, "MLDBM", $userinfo, 'rw' or die "Error tying \%user: $! "; 
 
my $username = $query->param('username'); 
 
# Jesli juz jest taki uzytkownik, to zakoncz program  
if (exists $users{$username}) 
{ 
    print $query->start_html(-title => "Username is taken!"); 
    print h1("Username is taken"); 
    print p("Sorry, but someone else has already taken the user name ", 
            "'$username'.  Please try again."); 
    print $query->end_html; 
 
    untie %users; 
 
    exit; 
} 
 
# Zaszyfruj hslo algorytmem MD5 i wynik zapisz w pliku 
$users{$username}->{password} = md5_hex($query->param('password')); 
 
# Zapisz adres e-mail jawnym tekstem 
$users{$username}->{email} = $query->param('email'); 
 
untie %users; 
 
# ------------------------------------------------------------ 
# Jesli wszystko pojdzie dobrze, poinformuj uzytkownika 
# ------------------------------------------------------------ 
 
print $query->start_html(-title => "Successful registration!"); 
print h1("Success"); 
print p("You have successfully been registered."); 
print $query->end_html; 
