#!/usr/bin/perl -T 
# nazwa pliku: create-graph.pl 
 
use strict; 
use warnings; 
use CGI; 
use CGI::Carp qw(fatalsToBrowser); 
use PNGgraph::linespoints; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Wyslij odpowiedni naglowek sygnalizujacy obraz PNG  
# ktory nie powinien byc przechowywany w pamieci podrecznej 
print $query->header(-type => "image/png", 
                     -expires => "-1d"); 
 
# Utworz nowa instancje klasy PNGgraph::bars 
my $graph = new PNGgraph::linespoints(500,500); 
 
# Zdefiniuj obrazowane dane 
my @data = ([qw(Sunday Monday Tuesday Wednesday  
                Thursday Friday Saturday)], 
            [20, 21, 23, 25, 29, 32, 20], 
            [15, 18, 16, 22, 25, 28, 16]); 
 
# Ustaw pare parametrow wykresu 
$graph->set(x_label => 'Day', 
            y_label => 'Temperature (in Celsius)', 
            title => 'Local Temperature', 
            y_tick_number     => 10, 
            y_label_skip      => 2); 
 
# Utworz legende 
$graph->set_legend(qw(High Low)); 
 
# Przygotuj wykres i wyslij go do przegladarki uzytkownika  
print $graph->plot(\@data); 
