#!/usr/bin/perl -T 
# nazwa pliku: cookie-input.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# ------------------------------------------------------------ 
# Pobierz dane od uzytkownika 
# ------------------------------------------------------------ 
 
# Pobierz nazwe uzytkownika 
my $name = $query->param("name") ||  
    $query->cookie(-name => "name") || ""; 
 
# Pobierz ulubiony kolor uzytkownika
my $color = $query->param("color") ||  
    $query->cookie(-name => "color") || ""; 
 
# ------------------------------------------------------------ 
# Utworz cookies 
# ------------------------------------------------------------ 
 
# Utworz nowe cookie dla nazwy, name 
my $name_cookie = $query->cookie(-name => "name", 
                                 -value => $name, 
                                 -expires => "+10m"); 
 
# Utworz nowe cookie dla koloru, color 
my $color_cookie = $query->cookie(-name => "color", 
                                  -value => $color, 
                                  -expires => "+10m"); 
 
# ------------------------------------------------------------ 
# Wyslij naglowki i tekst HTML  
# ------------------------------------------------------------ 
 
# Wyslij cookies w naglowku 
print $query->header(-type => "text/html", 
                     -cookie => [$name_cookie, $color_cookie]); 
 
# Teraz troche tekstu w HTML-u 
print $query->start_html(-title => "Cookies!"); 
print p("Enter a new value to change the cookie."); 
 
my $script_name = $query->script_name(); 
print qq{<form method="POST" action="$script_name">\n}; 
 
# Wstaw nazwe (name) do tego pola tekstowego 
print p("Your name:", textfield({name => "name", value => $name})); 
 
# Wstaw nazwe koloru do tego pola tekstowego 
print p("Your favorite color:", textfield({name => "color",  
                                           value => $color})); 
 
# Utworz przycisk zatwierdzenia: "submit"  
print qq{<p><input type="submit"></p>\n}; 
 
# Zakoncz formularz i strone HTML 
print "</form>\n"; 
print $query->end_html; 
