#!/usr/bin/perl -T 
# nazwa pliku: redirect-url.pl 
 
use strict; 
use warnings; 
use CGI; 
use Fcntl qw(:flock); 
 
# Wlacz automatyczne oproznianie buforow 
$| = 1; 
 
# Ustanow plik dziennika logfile
my $logfile = "/web/redirect-log.txt"; 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Pobierz adres URL, pod ktory uzytkownik ma byc przekierowany 
my $target = $query->param("target") || ""; 
 
# Zapisz adres w pliku dziennika na dysku 
if (open LOG, ">>$logfile") 
{ 
    # Zablokuj plik 
    flock LOG, LOCK_EX; 
 
    # Pobierz aktualna date i godzine 
    my $now = localtime(time); 
 
    # Zapisz date i godzine, URL oraz adres uzytkownika w dzienniku 
    print LOG "$now\t$target\t", $query->remote_addr, "\n"; 
 
    # Odblokuj plik 
    flock LOG, LOCK_UN; 
 
    close LOG; 
} 
# Jesli pliku nie da sie otworzyc, zakoncz program  
else 
{ 
    # Wyslij ostrzezenie do dziennika bledow serwera HTTP  
    warn("Error opening '$logfile': $!"); 
 
    # Wyslij cos do przegladarki uzytkownika 
    print $query->header("text/html"); 
    print $query->start_html(-title => "Error"); 
 
    print "<p>There was an error opening the logfile '$logfile'. 
             Please contact the webmaster.</p>"; 
 
    print $query->end_html; 
 
    die "Could not open $logfile: $! "; 
} 
 
# Teraz przekieruj do reklamodawcy 
print $query->redirect($target); 
