#!/usr/bin/perl 
# nazwa pliku: update-category.pl 
 
use strict; 
use warnings; 
use DBI; 
use Term::Complete; 
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
my %categories = (); 
 
# ------------------------------------------------------------ 
# Rozpocznij transakcje, ktora bedzie trwala do czasu  
# wywolania metody $dbh->commit() lub $dbh->rollback() 
$dbh->begin_work(); 
 
# Pobierz nazwy kategorii i uczyn je kluczami %categories 
my $sql = "SELECT category_name from Categories"; 
my $sth = $dbh->prepare($sql); 
$sth->execute; 
 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    # Dodaj nowy klucz do %categories, z wartoscia 1 
    $categories{$$rowref[0]} = 1; 
} 
 
# Zakoncz instrukcje 
$sth->finish(); 
 
my $old_category_name = ""; 
 
# Pobierz istniejaca kategorie uzywajac Term::Complete. Gdy przerwiemy 
# te petle, zmienna $old_category_name bedzie zawierac nazwe 
# istniejacej kategorii. 
until (defined $categories{$old_category_name}) 
{ 
    $old_category_name =  
        Complete("Enter an existing category: ", keys %categories); 
}  
 
# ------------------------------------------------------------ 
# Pobierz nowa nazwe kategorii 
 
print "Change '$old_category_name' to: "; 
my $new_category_name = <>; 
chomp $new_category_name; 
 
# Nazwa kategorii musi zawierac przynajmniej jeden znak 
if ($new_category_name !~ /\w/) 
{ 
    print "Error: The new category name cannot be blank!\n"; 
} 
 
# Jesli nazwy kategorii sa OK, sprawdz, czy nie ma juz jej  
# w bazie danych 
else 
{ 
    # Usun z nazwy niepotrzebna spacje 
    $new_category_name =~ s/^\s+//g; 
    $new_category_name =~ s/\s+$//g; 
 
    # Jesli $new_category_name jest w tabeli %categories, musimy 
    # przerwac, aby nazwy sie nie powtarzaly 
    if (defined $categories{$new_category_name}) 
    { 
        # Zasygnalizuj blad uzytkownikowi i wycofaj transakcje  
        print "Error: The category '$new_category_name' already exists!\n"; 
        $dbh->rollback(); 
        $dbh->disconnect(); 
        exit; 
    } 
 
    # Utworz zapytanie 
    my $sql = "UPDATE Categories "; 
    $sql .= "SET category_name = ? "; 
    $sql .= "WHERE category_name = ? "; 
 
    # Przygotuj instrukcje 
    my $number_of_affected_rows =  
        $dbh->do($sql, undef, $new_category_name, $old_category_name); 
 
    if ($number_of_affected_rows == 1) 
    { 
        # Raportuj wynik uzytkownikowi i zatwierdz transakcje  
        print "Renamed '$old_category_name' to '$new_category_name'.\n"; 
        $dbh->commit(); 
    }  
    else 
    { 
        # Raportuj blad uzytkownikowi i wycofaj transakcje  
        print "The category was not renamed.\n"; 
        $dbh->rollback(); 
    } 
} 
 
# Zakoncz polaczenie z baza danych 
$dbh->disconnect(); 
