#!/usr/bin/perl 
# nazwa pliku: insert-author.pl 
 
use strict; 
use warnings; 
use DBI; 
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       {'AutoCommit' => 1, 'PrintError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz od uzytkownika nazwisko nowego autora 
print "Enter the new author name: "; 
my $author_name = <>; 
chomp $author_name; 
 
# Nazwisko autora musi zawierac przynajmniej jeden znak 
if ($author_name !~ /\w/) 
{ 
    print "Author names must contain at least one "; 
    print "alphanumeric character.  Exiting.\n"; 
} 
 
# Jesli nazwisko autora jest OK, wstaw je 
else 
{ 
    # Usun niepotrzebne spacje z nazwiska autora 
    $author_name =~ s/^\s+//g; 
    $author_name =~ s/\s+$//g; 
 
    # Przygotuj zapytanie 
    my $sql = "INSERT INTO Authors (author_name) VALUES (?) "; 
 
    my $success = $dbh->do($sql, undef, $author_name); 
 
 
    if ($success) 
    { 
        print "Successfully inserted the author '$author_name'.\n"; 
    } 
    else 
    { 
        die "Fatal error executing the SQL '$sql': '$DBI::errstr' "; 
    } 
 
} 
 
# Zamkinij polaczenie z baza danych 
$dbh->disconnect; 
