#!/usr/bin/perl 
# nazwa pliku: simple-extract.pl 
 
use strict; 
use warnings; 
use LWP::Simple; 
use HTML::LinkExtor; 
 
# Pobierz URL z wiersza polecen 
my $url = $ARGV[0]; 
 
# Pobierz dokument sod adresu URL lub zakoncz 
my $text = get($url) 
    or die qq|Cannot retrieve "$url"|; 
 
# Utworz analizator (parser) 
my $parser = HTML::LinkExtor->new(\&callback); 
 
# Analizuj dokument, przyzywajac funkcje zwrotna dla kazdego znacznika HTML 
$parser->parse($text); 
 
sub callback 
{ 
    # Pobierz typ znacznika 
    my $tag = shift; 
 
    # Pobierz tablice asocjacyjna atrybutow 
    my %attributes = @_; 
 
    # Wyswietl informacje na ekranie 
    print "$tag:\n"; 
 
    foreach my $key (sort keys %attributes) 
    { 
        print "\t$key: $attributes{$key}\n"; 
    } 
} 
