#!/usr/bin/perl 
# nazwa pliku: httpd.pl 
 
use strict; 
use warnings; 
use IO::Socket; 
 
# Zdefiniuj przedrostek katalogu 
my $dir_prefix = "/usr/local/apache/htdocs/"; 
 
# Utworz gniazdo serwera 
my $socket = IO::Socket::INET->new(Proto => "tcp", 
                                   LocalPort => 8080, 
                                   Listen => SOMAXCONN, 
                                   Reuse => 1) 
    or die "Error opening socket: $! "; 
 
# Akceptuj nadchodzace polaczenia
while (my $client = $socket->accept()) { 
 
    # Pobiez zadanie od klienta 
    my $request = <$client>; 
 
    # Usun konczacy znak nowego wiersza 
    chomp $request; 
 
    # Podziel zadanie na metode i nazwe pliku, ignorujac 
    # wszystko, co pojawi sie po nich 
    my ($method, $filename, $ignore) = split /\s+/, $request; 
 
    # Upewnij sie, ze odebrane zadanie to GET 
    if ($method ne "GET") 
    { 
        print $client qq{Error!  Unknown method "$method"\n}; 
    } 
 
    # Je?li serwer odebral zadanie GET, zwraca  
    # zawartosc pliku---o ile taki istnieje 
    else 
    { 
        # Usun z poczatku nazwy pliku znaki . i /  
        $filename =~ s|^[/.]+||g; 
 
        my $full_filename = $dir_prefix . $filename; 
 
        # Wyswietl plik, jesli istnieje 
        if (open (FILE, $full_filename)) 
        { 
            while (<FILE>) 
            { 
                print $client $_; 
            } 
        } 
        # Jesli nie, zasygnalizuj blad 
        else 
        { 
            print $client "Error retrieving $filename: $!\n"; 
        } 
    } 
 
    # I to wszystko!  Zamknij polaczenie i czekaj na nastepnego klienta 
    close $client; 
} 
