#!/usr/bin/perl
# nazwa pliku: read-mldbm.pl

use strict;
use warnings;
use Fcntl;

# Wskaz, z jakiego wewnetrznego mechanizmu bedziesz korzystac 
use MLDBM qw(DB_File);

# Pobierz nasz argument nazwy pliku
my $file = $ARGV[0] or die "Brak argumentu!";

# Otworz plik DBM 
my %data;
tie %data, "MLDBM", $file, O_RDONLY
    or die "Bd wizania %data: $! ";

# Wyswietl kazda z par klucz-wartosc za pomoca odpowiedniej metody 
foreach my $key (sort keys %data)
{
    # Pobierz dane
    my $ref = $data{$key};

    # Obsluz skalary
    if (UNIVERSAL::isa($ref, "SCALAR"))
    {
        print "$key -> $$ref\n";
    }

    # Obsluz tablice
    elsif (UNIVERSAL::isa($ref, "ARRAY"))
    {
        my @array = @$ref;
        print "$key -> @array\n";
    }

    # Obsluz tablice asocjacyjne
    elsif (UNIVERSAL::isa($ref, "HASH"))
    {
        my %hash = %$ref;
        print "$key ->\n";

        foreach my $subkey (sort keys %hash)
        {
            print "\t$subkey -> $hash{$subkey}\n";
        }
    }
    else
    {
        print "Bd!\n";
    }
}    
