#!/usr/bin/perl
# nazwa pliku: bookshelf.pl

use strict;
use warnings;
use Book;

my @shelf = ();

# Dodaj pare ksiazek do polki
push @shelf, new Book("Philip and Alex's Guide to Web Publishing", 
                      "Philip Greenspun", "Morgan-Kaufmann", 
                      "1-55860-534-7", 44.95);

push @shelf, 
    new Book("Structure and Interpretation of Computer Programs", 
             "Abelson and Sussman", "MIT Press", 
             "0-262-01153-0", 65);

push @shelf, new Book("Essentials of User Interface Design", 
                      "Alan Cooper", "Prentice-Hall", 
                      "1-56884-322-4", 29.99);

# Wyswietl tytuly posortowane alfabetycznie
foreach my $book (sort {$a->get_title cmp $b->get_title} @shelf)
{
    print $book->get_title, "\n";
}
