package Apache::RememberMe; 
# nazwa pliku: RememberMe.pm 
 
use strict; 
use Apache::Request; 
use Apache::Cookie; 
 
# Importuj stale   
use Apache::Constants qw(OK DECLINED); 
 
sub handler 
{ 
    # ------------------------------------------------------------ 
    # Pobierz obiekt zadania Apache  
    my $r = shift; 
 
    # Utworz pseudo-CGI obiekt 
    my $request = new Apache::Request($r); 
 
    # Jaki jest moj adres URL? 
    my $self = $r->uri; 
 
    # ------------------------------------------------------------ 
    # Pobierz istniejace cookie identyfikatora, jesli jest  
 
    my %cookies = fetch Apache::Cokie; 
 
    my $id; 
 
    if (exists $cookies{'SESSION_ID'}) 
    { 
        $id = $cookies{'SESSION_ID'}->value; 
    } 
 
    # ------------------------------------------------------------ 
    # Pobierz sesje uzytkownika, jesli istnieje, bazujac na $id 
    my %session; 
 
    tie %session, 'Apache::Session::File', $id,  
    { 
     Directory => '/tmp/sessions', 
     LockDirectory   => '/var/lock/sessions' 
    }; 
 
    # ------------------------------------------------------------ 
    # Wyslij nowe cookie last_visited  
 
    my $cookie = Apache::Cookie->new($r,  
                                     -name => 'SESSION_ID', 
                                     -value => $session{_session_id}); 
 
    $cookie->bake(); 
 
    # ------------------------------------------------------------ 
    # Ustaw naglowek typu zawartosci, Content-Type  
    $r->content_type("text/html"); 
 
    # W razie wywolania przez metode GET, wyswietl formularz 
    if ($r->method eq "GET") 
    { 
        # Teraz wyslij naglowki odpowiedzi 
        $r->send_http_header; 
 
        # Pobierz adres e-mail uzytkownika z bazy danych sesji 
        my $email = $session{email}; 
 
        # Przygotuj formularz HTML  
        $r->print("<html>\n"); 
        $r->print("<head><title>Your e-mail address</title></head>\n"); 
        $r->print("<body>\n"); 
 
        $r->print(qq{<form method="POST" action="$self">\n}); 
 
        # Utworz pole tekstowe, wyswietlajac w razie  
        # potrzeby adres uzytkownika 
        $r->print("<p>Enter your e-mail address: \n"); 
        $r->print(qq{<input type="text" name="email" value="$email"></p>\n}); 
        $r->print(qq{<input type="submit">\n}); 
 
        $r->print("</body>\n"); 
        $r->print("</html>\n"); 
 
        # Poinformuj, ze wszystko poszlo dobrze 
        return OK; 
    } 
 
    # Obsluz metode POST, jesli ktos wprowadza nowa wartosc 
    elsif ($r->method eq "POST") 
    { 
        # Wyslij naglowki odpowiedzi HTTP 
        $r->send_http_header; 
 
        # Przechwyc adres e-mail  
        my $email = $request->param("email"); 
 
        # Zapisz adres w sesji uzytkownika 
        $session{email} = $email; 
 
        # Teraz przygotuj formularz HTML 
        $r->print("<html>\n"); 
        $r->print("<head><title>Updated.</title></head>\n"); 
        $r->print("<body>\n"); 
        $r->print(qq{<p>Your address was stored as "$email".</p>\n}); 
        $r->print("</body>\n"); 
        $r->print("</html>\n"); 
 
        # Poinformuj, ze wszystko poszlo dobrze 
        return OK; 
    } 
 
    else 
    { 
        # Poinformuj, ze nie chcesz tego obslugiwac 
        return DECLINED; 
    } 
} 
 
# Zwroc przyzywajacemu wartosc "true"  
1; 
