#!/usr/bin/perl -T 
# nazwa pliku: send-postcard.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
use Mail::Sendmail; 
use Digest::MD5 qw(md5_hex); 

# Szyfrujemy algorytmem MD5 pewna fraze (niejawna dla uzytkownika) oraz 
# identyfikator wiersza, co utrudni pobranie pocztowki osobie niepowolanej. 
my $secret_md5_phrase = 'coreperl-postcards'; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz dane od uzytkownika 
my $oid_md5 = 'dummy data'; 
my $sender_name = $query->param("sender_name"); 
my $sender_email = $query->param("sender_email"); 
my $recipient_name = $query->param("recipient_name"); 
my $recipient_email = $query->param("recipient_email"); 
my $message = $query->param("message"); 
 
# Rozpocznij transakcje 
$dbh->begin_work(); 
 
# Utworz zapytanie 
my $sql = "INSERT INTO Postcards "; 
$sql   .= "(oid_md5, sender_name, sender_email, "; 
$sql   .= " recipient_name, recipient_email, message) "; 
$sql   .= "VALUES (?, ?, ?, ?, ?, ?) "; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($oid_md5, $sender_name, $sender_email, $recipient_name, 
              $recipient_email, $message); 
 
# Teraz pobierz identyfikator OID wstawionego wiersza 
my $new_row_oid = $sth->{pg_oid_status}; 
 
# Uzywajac OID i sekretnej frazy, przygotuj zaszyfrowany identyfikator  
$oid_md5 = md5_hex($new_row_oid . $secret_md5_phrase); 
 
# Teraz aktualizuj wartosc zapytaniem UPDATE  
my $update_sql = "UPDATE Postcards ";
$update_sql .= "  SET oid_md5 = ? "; 
$update_sql .= "  WHERE oid = ? "; 
 
my $rows_modified =  
    $dbh->do($update_sql, undef, $oid_md5, $new_row_oid); 
 
# Zatwierdz transakcje, jesli wiersz zostal zmieniony 
if ($rows_modified) 
{ 
    $dbh->commit(); 
} 
else 
{ 
    $dbh->rollback(); 
} 
 
# Wyslij do odbiorcy e-mail, uzywajac modulu Mail::Sendmail 
my $mail_message = "You have received an electronic postcard.  To \n"; 
$mail_message   .= "retrieve it, go to \n\n"; 
$mail_message   .= "http://www.coreperl.com/cgi-bin/read-postcard.pl?id=$oid_md5\n"; 
 
my %mail = (To => $recipient_email, 
            From => $sender_email, 
            Message => $mail_message); 
 
sendmail (%mail); 
 
# Wyslij odpowiedni naglowek MIME  
print $query->header("text/html"); 
 
print $query->start_html(-title => "Postcard was sent successfully"); 
 
print h1("Successfully sent"),  
    p("Your postcard was sent successfully.", 
      "The recipient has been sent an e-mail message with", 
      "directions for retrieving it. You can look at the card", 
      a({href => "/cgi-bin/read-postcard.pl?id=$oid_md5"},  "here.")); 
 
print $query->end_html; 
 
# Zamknij uchwyt tej instrukcji 
$sth->finish; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
