#!/usr/bin/perl -T 
# nazwa pliku: graph2-range.pl 
 
use strict; 
use warnings; 
use CGI qw(:standard); 
use CGI::Carp qw(fatalsToBrowser); 
use DBI; 
use PNGgraph::linespoints; 
 
# Zadeklaruj tablice warto?ci i dat 
my (@values1, @values2, @dates); 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Polacz sie z baza danych 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz symbole interesujace uzytkownika 
my $symbol1 = $query->param("symbol1") ||  
    die "No symbol1 provided; try again."; 
 
my $symbol2 = $query->param("symbol2") ||  
    die "No symbol2 provided; try again."; 
 
# Symbole sa duzymi literami, wiec je przetlumacz  
$symbol1 = "\U$symbol1"; 
$symbol2 = "\U$symbol2"; 
 
# Pobierz startowa i koncowa date 
my $start_date = $query->param("start_date"); 
my $end_date = $query->param("end_date"); 
 
# Utworz zapytanie 
my $sql =  "SELECT S.symbol, V.stock_value, V.value_timestamp "; 
$sql .= "  FROM StockSymbols S, StockValues V "; 
$sql .= "  WHERE (S.symbol = ? OR S.symbol = ?)"; 
$sql .= "    AND S.symbol_id = V.symbol_id "; 
 
my @placeholders = (); 
if ($start_date) 
{ 
    $sql .= "AND V.value_timestamp >= ? "; 
    push @placeholders, $start_date; 
} 
 
if ($end_date) 
{ 
    $sql .= "AND V.value_timestamp <= ? "; 
    push @placeholders, $end_date; 
} 
 
$sql .= "ORDER BY V.value_timestamp"; 
 
# Przygotuj zapytanie 
my $sth = $dbh->prepare($sql); 
 
# Wykonaj zapytanie 
$sth->execute($symbol1, $symbol2, @placeholders); 
 
# Utworz instancje klasy wykresu PNGgraph::linespoints 
my $graph = new PNGgraph::linespoints(500,500); 
 
# Pobierz wyniki z wiersza 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    my ($symbol, $value, $date) = @$rowref; 
 
    # Dodaj nowa wartosc i date do tablic  
    push @values1, ($symbol eq $symbol1 ? $value : ""); 
    push @values2, ($symbol eq $symbol2 ? $value : ""); 
    push @dates, $date; 
} 
 
# Jesli baza nic nie zwrocila, przygotuj komunikat o bledzie  
if ($sth->rows() == 0) 
{ 
    print $query->header("text/html"); 
    print $query->start_html(-title => "No data available"); 
    print h1("No data available"), 
        p("Sorry, but no data is available for $symbol1 or", 
          "$symbol2 during this period."); 
    print $query->end_html; 
    exit; 
} 
 
# Zdefiniuj dane dla wykresu 
my @data = (\@dates, \@values1, \@values2); 
 
# Zdefiniuj pare parametrow wykresu 
$graph->set(x_label => 'Dates', 
            y_label => 'Stock prices', 
            title => "Price of $symbol1 vs. $symbol2"); 
 
# Wyslij odpowiedni naglowek MIME  
print $query->header("image/png"); 
 
# Przygotuj wykres i wyslij go do przegladarki uzytkownika  
print $graph->plot(\@data); 
 
# Zakoncz te instrukcje 
$sth->finish; 
 
# Zamknij polaczenie z baza danych 
$dbh->disconnect; 
