#!/usr/bin/perl -T 
# nazwa pliku: graphics-output.pl 
 
use strict; 
use warnings; 
use CGI; 
use CGI::Carp qw(fatalsToBrowser); 
use GD; 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Wyslij naglowek MIME wskazujacy, ze wysylamy plik PNG 
print $query->header(-type => "image/png", 
                    -expires => "-1h"); 
 
# Utworz nowy obiekt obrazu 
my $image = new GD::Image(100,100); 
 
# ------------------------------------------------------------ 
# Zdefiniuj kolory i rozmiary 
# ------------------------------------------------------------ 
my $white = $image->colorAllocate(255,255,255); 
 
my $outline_color = $image->colorAllocate(int rand 255, 
                                          int rand 255, int rand 255); 
 
my $fill_color = $image->colorAllocate(int rand 255, 
                                       int rand 255, int rand 255); 
 
my $size = int rand 100; 
 
# Ustaw kolor tla jako bialy 
$image->transparent($white); 
 
# ------------------------------------------------------------ 
# Narysuj okrag o kolorze $outline_color 
$image->arc(50,50,$size,$size,0,360, $outline_color); 
 
# Wypelnij okrag kolorem $fill_color 
$image->fill(50,50, $fill_color); 
 
# Konwertuj obraz na format PNG i wyslij go 
# do przegladarki uzytkownika 
print $image->png; 
